/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.kitesdk.data.CompressionType;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Formats;
import org.kitesdk.data.View;
import org.kitesdk.data.mapreduce.DatasetKeyOutputFormat;
import org.kitesdk.data.spi.SchemaValidationUtil;

public final class ParquetJob {
    public static final Log LOG = LogFactory.getLog((String)ParquetJob.class.getName());
    private static final String CONF_AVRO_SCHEMA = "parquetjob.avro.schema";
    static final String CONF_OUTPUT_CODEC = "parquetjob.output.codec";

    private ParquetJob() {
    }

    public static Schema getAvroSchema(Configuration conf) {
        return new Schema.Parser().parse(conf.get(CONF_AVRO_SCHEMA));
    }

    public static CompressionType getCompressionType(Configuration conf) {
        CompressionType defaults = Formats.PARQUET.getDefaultCompressionType();
        String codec = conf.get(CONF_OUTPUT_CODEC, defaults.getName());
        try {
            return CompressionType.forName((String)codec);
        }
        catch (IllegalArgumentException ex) {
            LOG.warn((Object)String.format("Unsupported compression type '%s'. Fallback to '%s'.", codec, defaults));
            return defaults;
        }
    }

    public static void configureImportJob(Configuration conf, Schema schema, String uri, boolean reuseExistingDataset, boolean overwrite) throws IOException {
        Dataset dataset;
        if (reuseExistingDataset || overwrite) {
            try {
                dataset = (Dataset)Datasets.load((String)uri);
            }
            catch (DatasetNotFoundException ex) {
                dataset = ParquetJob.createDataset(schema, ParquetJob.getCompressionType(conf), uri);
            }
            Schema writtenWith = dataset.getDescriptor().getSchema();
            if (!SchemaValidationUtil.canRead((Schema)writtenWith, (Schema)schema)) {
                throw new IOException(String.format("Expected schema: %s%nActual schema: %s", writtenWith, schema));
            }
        } else {
            dataset = ParquetJob.createDataset(schema, ParquetJob.getCompressionType(conf), uri);
        }
        conf.set(CONF_AVRO_SCHEMA, schema.toString());
        if (overwrite) {
            DatasetKeyOutputFormat.configure((Configuration)conf).overwrite((View)dataset);
        } else {
            DatasetKeyOutputFormat.configure((Configuration)conf).writeTo((View)dataset);
        }
    }

    private static Dataset createDataset(Schema schema, CompressionType compressionType, String uri) {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(schema).format(Formats.PARQUET).compressionType(compressionType).build();
        return (Dataset)Datasets.create((String)uri, (DatasetDescriptor)descriptor, GenericRecord.class);
    }
}

