/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.config.ConfigurationHelper;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetFTPRecordReader;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetInputSplit;
import org.apache.sqoop.util.MainframeFTPClientUtils;

public class MainframeDatasetInputFormat<T extends SqoopRecord>
extends InputFormat<LongWritable, T> {
    private static final Log LOG = LogFactory.getLog(MainframeDatasetInputFormat.class);

    public RecordReader<LongWritable, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new MainframeDatasetFTPRecordReader();
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        Configuration conf = job.getConfiguration();
        String dsName = conf.get("mapreduce.mainframe.input.dataset.name");
        LOG.info((Object)("Datasets to transfer from: " + dsName));
        List<String> datasets = this.retrieveDatasets(dsName, conf);
        if (datasets.isEmpty()) {
            throw new IOException("No sequential datasets retrieved from " + dsName);
        }
        int count = datasets.size();
        int chunks = Math.min(count, ConfigurationHelper.getJobNumMaps(job));
        for (int i = 0; i < chunks; ++i) {
            splits.add(new MainframeDatasetInputSplit());
        }
        int j = 0;
        block1: while (j < count) {
            for (InputSplit sp : splits) {
                if (j == count) continue block1;
                ((MainframeDatasetInputSplit)sp).addDataset(datasets.get(j));
                ++j;
            }
        }
        return splits;
    }

    protected List<String> retrieveDatasets(String dsName, Configuration conf) throws IOException {
        return MainframeFTPClientUtils.listSequentialDatasets(dsName, conf);
    }
}

