/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import org.apache.sqoop.manager.oracle.OraOopUtilities;

public class OraOopJdbcUrl {
    private String jdbcConnectString;

    public OraOopJdbcUrl(String jdbcConnectString) {
        if (jdbcConnectString == null) {
            throw new IllegalArgumentException("The jdbcConnectionString argument must not be null.");
        }
        if (jdbcConnectString.isEmpty()) {
            throw new IllegalArgumentException("The jdbcConnectionString argument must not be empty.");
        }
        this.jdbcConnectString = jdbcConnectString;
    }

    public OraOopUtilities.JdbcOracleThinConnection parseJdbcOracleThinConnectionString() throws OraOopUtilities.JdbcOracleThinConnectionParsingError {
        String hostName = null;
        int port = 0;
        String sid = null;
        String service = null;
        String jdbcUrl = this.jdbcConnectString.trim();
        int paramsIdx = jdbcUrl.indexOf("?");
        if (paramsIdx > -1) {
            jdbcUrl = jdbcUrl.substring(0, paramsIdx);
        }
        String[] jdbcFragments = jdbcUrl.trim().split(":");
        for (int idx = 0; idx < jdbcFragments.length; ++idx) {
            jdbcFragments[idx] = jdbcFragments[idx].trim();
        }
        if (jdbcFragments.length < 4 || jdbcFragments.length > 6) {
            throw new OraOopUtilities.JdbcOracleThinConnectionParsingError(String.format("There should be 4, 5 or 6 colon-separated pieces of data in the JDBC URL, such as:\n\tjdbc:oracle:<driver-type>:@tnsname\n\tjdbc:oracle:<driver-type>:@<host>:<port>:<sid>\n\tjdbc:oracle:<driver-type>:@<host>:<port>/<service>\n\tjdbc:oracle:<driver-type>:@<host>:<port>/<service>?<parameters>\nThe JDBC URL specified was:\n%s\nwhich contains %d pieces of colon-separated data.", this.jdbcConnectString, jdbcFragments.length));
        }
        if (!jdbcFragments[0].equalsIgnoreCase("jdbc")) {
            throw new OraOopUtilities.JdbcOracleThinConnectionParsingError("The first item in the colon-separated JDBC URL must be \"jdbc\".");
        }
        if (!jdbcFragments[1].equalsIgnoreCase("oracle")) {
            throw new OraOopUtilities.JdbcOracleThinConnectionParsingError("The second item in the colon-separated JDBC URL must be \"oracle\".");
        }
        if (!jdbcFragments[2].equalsIgnoreCase("thin")) {
            throw new OraOopUtilities.JdbcOracleThinConnectionParsingError(String.format("The Oracle \"thin\" JDBC driver is not being used.\nThe third item in the colon-separated JDBC URL must be \"thin\", not \"%s\".", jdbcFragments[2]));
        }
        hostName = jdbcFragments[3];
        if (hostName.isEmpty() || hostName.equalsIgnoreCase("@")) {
            throw new OraOopUtilities.JdbcOracleThinConnectionParsingError("The fourth item in the colon-separated JDBC URL (the host name) must not be empty.");
        }
        if (!hostName.startsWith("@")) {
            throw new OraOopUtilities.JdbcOracleThinConnectionParsingError("The fourth item in the colon-separated JDBC URL (the host name) must a prefixed with the \"@\" character.");
        }
        String portStr = "";
        String tnsName = "";
        switch (jdbcFragments.length) {
            case 6: {
                portStr = jdbcFragments[4];
                sid = jdbcFragments[5];
                break;
            }
            case 5: {
                String[] portAndService = jdbcFragments[4].split("/");
                if (portAndService.length != 2) {
                    throw new OraOopUtilities.JdbcOracleThinConnectionParsingError("The fifth colon-separated item in the JDBC URL (<port>/<service>) must contain two items separated by a \"/\".");
                }
                portStr = portAndService[0].trim();
                service = portAndService[1].trim();
                break;
            }
            case 4: {
                tnsName = jdbcFragments[3].trim();
                break;
            }
            default: {
                throw new OraOopUtilities.JdbcOracleThinConnectionParsingError("Internal error parsing JDBC connection string.");
            }
        }
        if (jdbcFragments.length > 4) {
            if (portStr.isEmpty()) {
                throw new OraOopUtilities.JdbcOracleThinConnectionParsingError("The fifth item in the colon-separated JDBC URL (the port) must not be empty.");
            }
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException ex) {
                throw new OraOopUtilities.JdbcOracleThinConnectionParsingError(String.format("The fifth item in the colon-separated JDBC URL (the port) must be a valid number.\n\"%s\" could not be parsed as an integer.", portStr));
            }
            if (port <= 0) {
                throw new OraOopUtilities.JdbcOracleThinConnectionParsingError(String.format("The fifth item in the colon-separated JDBC URL (the port) must be greater than zero.\n\"%s\" was specified.", portStr));
            }
        }
        if (sid == null && service == null && tnsName == null) {
            throw new OraOopUtilities.JdbcOracleThinConnectionParsingError("The JDBC URL does not contain a SID or SERVICE. The URL should look like one of these:\n\tjdbc:oracle:<driver-type>:@tnsname\n\tjdbc:oracle:<driver-type>:@<host>:<port>:<sid>\n\tjdbc:oracle:<driver-type>:@<host>:<port>/<service>\n\tjdbc:oracle:<driver-type>:@<host>:<port>/<service>?<parameters>\n\tjdbc:oracle:<driver-type>:@//<host>:<port>/<service>\n\tjdbc:oracle:<driver-type>:@<host>:<port>/<service>?<parameters>");
        }
        OraOopUtilities.JdbcOracleThinConnection result = new OraOopUtilities.JdbcOracleThinConnection(hostName.replaceFirst("^[@][/]{0,2}", ""), port, sid, service, tnsName.replaceFirst("^[@][/]{0,2}", ""));
        return result;
    }

    public String getConnectionUrl() {
        return this.jdbcConnectString;
    }
}

