/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.postgresql;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.config.ConfigurationHelper;
import com.cloudera.sqoop.manager.ExportJobContext;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.sqoop.mapreduce.JdbcExportJob;
import org.apache.sqoop.mapreduce.postgresql.PostgreSQLCopyExportMapper;

public class PostgreSQLCopyExportJob
extends JdbcExportJob {
    public static final Log LOG = LogFactory.getLog((String)PostgreSQLCopyExportJob.class.getName());

    public PostgreSQLCopyExportJob(ExportJobContext context) {
        super(context);
    }

    public PostgreSQLCopyExportJob(ExportJobContext ctxt, Class<? extends Mapper> mapperClass, Class<? extends InputFormat> inputFormatClass, Class<? extends OutputFormat> outputFormatClass) {
        super(ctxt, mapperClass, inputFormatClass, outputFormatClass);
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        return PostgreSQLCopyExportMapper.class;
    }

    @Override
    protected void configureMapper(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        if (this.isHCatJob) {
            throw new IOException("Sqoop-HCatalog Integration is not supported.");
        }
        switch (this.getInputFileType()) {
            case AVRO_DATA_FILE: {
                throw new IOException("Avro data file is not supported.");
            }
        }
        job.setMapperClass(this.getMapperClass());
        ConfigurationHelper.setJobMapSpeculativeExecution(job, false);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(NullWritable.class);
    }

    @Override
    protected void propagateOptionsToJob(Job job) {
        super.propagateOptionsToJob(job);
        SqoopOptions opts = this.context.getOptions();
        Configuration conf = job.getConfiguration();
        if (opts.getNullStringValue() != null) {
            conf.set("postgresql.null.string", opts.getNullStringValue());
        }
        this.setDelimiter("postgresql.input.field.delim", opts.getInputFieldDelim(), conf);
        this.setDelimiter("postgresql.input.record.delim", opts.getInputRecordDelim(), conf);
        this.setDelimiter("postgresql.input.enclosedby", opts.getInputEnclosedBy(), conf);
        this.setDelimiter("postgresql.input.escapedby", opts.getInputEscapedBy(), conf);
        conf.setBoolean("postgresql.input.encloserequired", opts.isInputEncloseRequired());
    }

    private void setDelimiter(String prop, char val, Configuration conf) {
        switch (val) {
            case '\u0000': {
                break;
            }
            default: {
                conf.set(prop, String.valueOf(val));
            }
        }
    }
}

