import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.spark_util import SparkUtil
from pyspark.sql import functions as F
from utils.db_util import DBUtil


class ExportAsinDetailBase(object):

    def __init__(self, site_name="us", date_type="month", date_info="2022-01"):
        self.site_name = site_name
        self.date_type = date_type
        self.date_info = date_info
        app_name = f"{self.__class__.__name__}:{site_name}:{date_type}:{date_info}"
        self.spark = SparkUtil.get_spark_session(app_name)

        self.df_flow_asin = self.spark.sql(f"select 1+1;")
        self.df_fb_info = self.spark.sql(f"select 1+1;")
        self.df_save = self.spark.sql(f"select 1+1;")

    def run(self):
        self.read_data()
        self.handle_data()
        self.save_data()

    def read_data(self):
        # 读取流量选品月数据
        sql1 = f"""
        select 
            site_name,
            asin,
            asin_weight,
            asin_bought_month,
            asin_category_desc,
            asin_img_url,
            asin_title,
            asin_brand_name,
            account_name,
            asin_buy_box_seller_type,
            asin_launch_time,
            asin_img_num,
            case when variation_num > 0 then 1 else 0 end as variation_flag,
            variation_num,
            asin_ao_val,
            category_first_id,
            category_id,
            parent_asin,
            first_category_rank,
            asin_price,
            asin_rating,
            asin_total_comments
        from dwt_flow_asin 
        where site_name = '{self.site_name}' 
          and date_type = '{self.date_type}' 
          and date_info = '{self.date_info}' 
          and asin_type in (0, 1) 
          and asin_bought_month >= 50 
          and (
            asin_category_desc not in (
            "Health & Household›Baby & Child Care›Health Care›Allergy Medicine",
            "Health & Household›Baby & Child Care›Health Care›Children's Vitamins",
            "Health & Household›Baby & Child Care›Health Care›Cold & Flu Remedies",
            "Health & Household›Baby & Child Care›Health Care›Pain Relievers›Aspirin",
            "Health & Household›Baby & Child Care›Health Care›Pain Relievers›Non-Aspirin›Acetaminophen",
            "Health & Household›Baby & Child Care›Health Care›Pain Relievers›Non-Aspirin›Ibuprofen",
            "Health & Household›Health Care›Over-the-Counter Medication›Allergy, Sinus & Asthma›Allergy Eye Drops",
            "Health & Household›Health Care›Eye Health›Dry Eye Relief",
            "Health & Household›Health Care›Eye Health›Moisturizing Eye Drops",
            "Health & Household›Health Care›First Aid›Antibiotics & Antiseptics›Ointments",
            "Health & Household›Health Care›First Aid›Antifungals›Athletes Foot Remedies",
            "Health & Household›Health Care›First Aid›Antifungals›Jock Itch Treatments",
            "Health & Household›Health Care›First Aid›Antifungals›Nail Fungus Treatments",
            "Health & Household›Health Care›First Aid›Burn Care",
            "Health & Household›Health Care›First Aid›Itching & Rash Treatments›Cortisone Treatments",
            "Health & Household›Health Care›First Aid›Itching & Rash Treatments›Poison Ivy Relief",
            "Health & Household›Health Care›Over-the-Counter Medication›Allergy, Sinus & Asthma›Allergy Medicine",
            "Health & Household›Health Care›Over-the-Counter Medication›Allergy, Sinus & Asthma›Asthma Medicine",
            "Health & Household›Health Care›Over-the-Counter Medication›Allergy, Sinus & Asthma›Sinus Medicine",
            "Health & Household›Health Care›Over-the-Counter Medication›Cough & Cold›Chest Rubs",
            "Health & Household›Health Care›Over-the-Counter Medication›Cough & Cold›Cold & Flu Relief",
            "Health & Household›Health Care›Over-the-Counter Medication›Cough & Cold›Coughing & Sore Throats›Cough Drops",
            "Health & Household›Health Care›Over-the-Counter Medication›Cough & Cold›Coughing & Sore Throats›Cough Syrups",
            "Health & Household›Health Care›Over-the-Counter Medication›Cough & Cold›Nasal Sprays & Drops›Decongestant Sprays",
            "Health & Household›Health Care›Over-the-Counter Medication›Cough & Cold›Nasal Sprays & Drops›Moisturizing Sprays",
            "Health & Household›Health Care›Over-the-Counter Medication›Digestion & Nausea›Antacids",
            "Health & Household›Health Care›Over-the-Counter Medication›Digestion & Nausea›Diarrhea Relief",
            "Health & Household›Health Care›Over-the-Counter Medication›Digestion & Nausea›Gas Relief",
            "Health & Household›Health Care›Over-the-Counter Medication›Digestion & Nausea›Lactose Intolerance",
            "Health & Household›Health Care›Over-the-Counter Medication›Digestion & Nausea›Laxatives",
            "Health & Household›Health Care›Over-the-Counter Medication›Eczema, Psoriasis & Rosacea Care",
            "Health & Household›Health Care›Over-the-Counter Medication›Pain Relievers›Alternative Pain Relief",
            "Health & Household›Health Care›Over-the-Counter Medication›Pain Relievers›Arthritis",
            "Health & Household›Health Care›Over-the-Counter Medication›Pain Relievers›Aspirin",
            "Health & Household›Health Care›Over-the-Counter Medication›Pain Relievers›Hemorrhoid Care",
            "Health & Household›Health Care›Over-the-Counter Medication›Pain Relievers›Joint & Muscle Pain Relief›Treatments›Pain Relief Rubs",
            "Health & Household›Health Care›Over-the-Counter Medication›Pain Relievers›Menstrual Pain Relief",
            "Health & Household›Health Care›Over-the-Counter Medication›Pain Relievers›Non-Aspirin›Acetaminophen",
            "Health & Household›Health Care›Over-the-Counter Medication›Pain Relievers›Non-Aspirin›Ibuprofen",
            "Health & Household›Health Care›Over-the-Counter Medication›Pain Relievers›Non-Aspirin›Naproxen Sodium",
            "Health & Household›Oral Care›Oral Pain Relief›Medications",
            "Health & Household›Health Care›Over-the-Counter Medication›Pain Relievers›Urinary Tract Infection Treatments",
            "Health & Household›Health Care›Over-the-Counter Medication›Sleep Aids",
            "Health & Household›Health Care›Smoking Cessation›Nicotine Gums & Lozenges",
            "Pet Supplies›Cats›Health Supplies›Itch Remedies",
            "Pet Supplies›Cats›Health Supplies›Relaxants",
            "Pet Supplies›Cats›Health Supplies›Prescription Medications",
            "Pet Supplies›Cats›Health Supplies›Non-Prescription Medications",
            "Pet Supplies›Cats›Health Supplies›Hairball Remedy Pastes & Gels",
            "Pet Supplies›Cats›Health Supplies›Eye Care",
            "Pet Supplies›Cats›Health Supplies›Ear Care",
            "Pet Supplies›Cats›Health Supplies›Digestive Remedies",
            "Pet Supplies›Cats›Health Supplies›Dental Care",
            "Pet Supplies›Cats›Health Supplies›Wormers",
            "Pet Supplies›Dogs›Health Supplies›Digestive Remedies",
            "Pet Supplies›Dogs›Health Supplies›Ear Care",
            "Pet Supplies›Dogs›Health Supplies›Eye Care",
            "Pet Supplies›Dogs›Health Supplies›Hip & Joint Care",
            "Pet Supplies›Dogs›Health Supplies›Itch Remedies",
            "Pet Supplies›Dogs›Health Supplies›Milk Replacers",
            "Pet Supplies›Dogs›Health Supplies›Non-Prescription Medications",
            "Pet Supplies›Dogs›Health Supplies›Prescription Medications",
            "Pet Supplies›Dogs›Health Supplies›Relaxants",
            "Pet Supplies›Horses›Health Supplies›Hoof Care",
            "Pet Supplies›Horses›Health Supplies›Liniments",
            "Pet Supplies›Horses›Health Supplies›Prescription Medications",
            "Pet Supplies›Dogs›Grooming›Styptic Gels & Powders",
            "Pet Supplies›Horses›Health Supplies›Hip & Joint Care",
            "Pet Supplies›Dogs›Health Supplies›Wormers",
            "Pet Supplies›Cats›Health Supplies›Hip & Joint Care",
            "Health & Household›Diet & Sports Nutrition›Endurance & Energy›Candy & Mints",
            "Health & Household›Diet & Sports Nutrition›Endurance & Energy›Chews & Gels",
            "Health & Household›Diet & Sports Nutrition›Endurance & Energy›Herbals",
            "Health & Household›Diet & Sports Nutrition›Endurance & Energy›Powders",
            "Health & Household›Diet & Sports Nutrition›Endurance & Energy›Shots",
            "Health & Household›Diet & Sports Nutrition›Endurance & Energy›Supplements",
            "Health & Household›Diet & Sports Nutrition›Nutrition Bars & Drinks›Nutrition Bars›Endurance & Energy Bars",
            "Health & Household›Diet & Sports Nutrition›Nutrition Bars & Drinks›Nutrition Bars›Food Bars",
            "Health & Household›Diet & Sports Nutrition›Nutrition Bars & Drinks›Nutrition Bars›Protein Bars",
            "Health & Household›Diet & Sports Nutrition›Weight Loss›Ready to Drink Shakes",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›7-Keto",
            "Health & Household›Vitamins, Minerals & Supplements›Amino Acids›5-HTP",
            "Health & Household›Vitamins, Minerals & Supplements›Amino Acids›Acetyl-L-Carnitine",
            "Health & Household›Vitamins, Minerals & Supplements›Amino Acids›BCAAs",
            "Health & Household›Vitamins, Minerals & Supplements›Amino Acids›Creatine",
            "Health & Household›Vitamins, Minerals & Supplements›Amino Acids›L-Arginine",
            "Health & Household›Vitamins, Minerals & Supplements›Amino Acids›L-Glutamine",
            "Health & Household›Vitamins, Minerals & Supplements›Amino Acids›L-Lysine",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›CLA",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Electrolyte Replacements",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›Fat Burners",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›L-Carnitine",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Post-Workout & Recovery",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Pre-Workout›Nitric Oxide Boosters",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Pre-Workout›Powders",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Protein›Blends",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Protein›Egg",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Protein›Plant›Hemp",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Protein›Plant›Pea",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Protein›Plant›Rice",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Protein›Plant›Soy",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Protein›Ready to Drink",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Protein›Whey",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Testosterone Boosters",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Weight Gainers",
            "Health & Household›Diet & Sports Nutrition›Weight Loss›Appetite Control & Suppressants",
            "Health & Household›Diet & Sports Nutrition›Weight Loss›Diet Kits & Systems",
            "Health & Household›Vitamins, Minerals & Supplements",
            "Health & Household›Diet & Sports Nutrition›Weight Loss›Supplements›Detox & Cleanse",
            "Health & Household›Vitamins, Minerals & Supplements›Digestive Supplements›Dietary Fibers",
            "Health & Household›Diet & Sports Nutrition›Weight Loss›Supplements›Diuretics",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Alpha Lipoic Acid",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Garcinia Cambogia",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Green Coffee Bean Extract",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Fruit Extracts›Raspberry Ketones",
            "Health & Household›Health Care›Women's Health›Menopause",
            "Health & Household›Health Care›Women's Health›Yeast Infection Treatments",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Astaxanthin",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Beta Carotenes",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Carotenoids",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›CoQ10",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Colloidal Minerals›Colloidal Gold",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Colloidal Minerals›Colloidal Silver",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Combinations",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›DMAE",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›French Maritime Pine Bark Extract",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Lutein",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Lycopene",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Curcumin",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Polyphenol›Flavonoids›Bioflavonoids",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Polyphenol›Flavonoids›Quercetin",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Polyphenol›Flavonoids›Rutin",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Fruit Extracts›Grape Seed Extract",
            "Health & Household›Vitamins, Minerals & Supplements›Antioxidants›Resveratrol",
            "Health & Household›Vitamins, Minerals & Supplements›Blended Vitamin & Mineral Supplements",
            "Health & Household›Vitamins, Minerals & Supplements›Chondroitin & Glucosamine›Chondroitin",
            "Health & Household›Vitamins, Minerals & Supplements›Chondroitin & Glucosamine›Combinations",
            "Health & Household›Vitamins, Minerals & Supplements›Chondroitin & Glucosamine›Glucosamine",
            "Health & Household›Vitamins, Minerals & Supplements›Collagen",
            "Health & Household›Vitamins, Minerals & Supplements›Digestive Supplements›Charcoal",
            "Health & Household›Vitamins, Minerals & Supplements›Digestive Supplements›Prebiotics",
            "Health & Household›Vitamins, Minerals & Supplements›Digestive Supplements›Probiotics›Acidophilus",
            "Health & Household›Vitamins, Minerals & Supplements›Enzymes›Bromelain",
            "Health & Household›Vitamins, Minerals & Supplements›Enzymes›Lactase",
            "Health & Household›Vitamins, Minerals & Supplements›Enzymes›Lipase",
            "Health & Household›Vitamins, Minerals & Supplements›Enzymes›Multi-Enzymes",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›Black Currant Oil",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›Black Seed Oil",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›Combinations",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›DHA",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›EPA",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›Fish Oil",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›Flax Seed Oil",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›Krill Oils",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›Linseed Oil",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›Omega Oils›Omega 3-6-9",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›Omega Oils›Omega-3",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›Omega Oils›Omega-6",
            "Health & Household›Vitamins, Minerals & Supplements›Essential Fatty Acids›Omega Oils›Omega-9",
            "Health & Household›Vitamins, Minerals & Supplements›Glandular Extracts›Adrenal Extracts",
            "Health & Household›Vitamins, Minerals & Supplements›Glandular Extracts›Liver Extracts",
            "Health & Household›Vitamins, Minerals & Supplements›Glandular Extracts›Thymus Extracts",
            "Health & Household›Vitamins, Minerals & Supplements›Glandular Extracts›Thyroid Extracts",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Alfalfa",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Magnesium",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Andrographis Paniculata",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Arjuna",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Artichoke",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Ashwagandha",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Astragalus",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Bacopa Monnieri",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Bael",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Black Cohosh",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Boswellia Serrata",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Calamus",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Cayenne",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Chamomile",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Chlorella",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Chlorophyll",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Cinnamon",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Cissus Quadrangularis",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Dong Quai",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Echinacea",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Edible Camphor",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Evening Primrose",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Flaxseed",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Fruit Extracts›Cranberry",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Fruit Extracts›Bilberry",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Fruit Extracts›Elderberry",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Garlic",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Giloy",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Ginger",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Ginkgo Biloba",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Ginseng",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Goldenseal",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Gotu Kola",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Green Tea",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Gymnema Sylvestre",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Haritaki",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Hawthorn",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Holy Basil",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Horny Goat Weed",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Karela",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Kava Kava",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Licorice Root",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Manjishtha",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Marshmallow Root",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Milk Thistle",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Mucuna Pruriens",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Muira Puama",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Mushrooms",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Nagarmotha",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Neem",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Nettle",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Nisoth",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Noni",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Olive Leaf",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Oregano",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Papaya Leaf",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Pippali",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Psyllium",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Punarnava",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Red Yeast Rice",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Sarpagandha",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Saw Palmetto",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Shankh Bhasma",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Shatavari",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Shilajit",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Shuddha Guggulu",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Spirulina",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›St. John's Wort",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Stevia",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Tribulus",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Trikatu",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Triphala",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Turmeric",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Valerian",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Vasaka",
            "Health & Household›Vitamins, Minerals & Supplements›Herbal Supplements›Yohimbe",
            "Health & Household›Vitamins, Minerals & Supplements›Hyaluronic Acid",
            "Health & Household›Vitamins, Minerals & Supplements›Lipid›Choline",
            "Health & Household›Vitamins, Minerals & Supplements›Lipid›Lecithin",
            "Health & Household›Vitamins, Minerals & Supplements›MCT Oil",
            "Health & Household›Vitamins, Minerals & Supplements›MSM",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Calcium",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Chromium",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Copper",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Iodine",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Iron",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Manganese",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Multiminerals",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Potassium",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Selenium",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Silicon",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Sodium",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Trace Minerals",
            "Health & Household›Vitamins, Minerals & Supplements›Minerals›Zinc",
            "Health & Household›Vitamins, Minerals & Supplements›Royal Jelly",
            "Health & Household›Vitamins, Minerals & Supplements›Sleep Supplements",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Multivitamins",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Prenatal Vitamins",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin A",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin C",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin D",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin E",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin K1",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin B›B-Complex",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin B›B1 (Thiamine)",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin B›B12",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin B›B2 (Riboflavin)",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin B›B3 (Niacin)",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin B›B6 (Pyridoxal Phosphate)",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin B›B5 (Pantothenic Acid)",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin B›B7 (Biotin)",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin B›B8 (Inositol)",
            "Health & Household›Vitamins, Minerals & Supplements›Vitamins›Vitamin B›B9 (Folic Acid)",
            "Pet Supplies›Cats›Health Supplies›Supplements & Vitamins›Probiotics",
            "Pet Supplies›Cats›Health Supplies›Supplements & Vitamins›Multivitamins",
            "Pet Supplies›Cats›Health Supplies›Supplements & Vitamins›Herbal Supplements",
            "Pet Supplies›Cats›Health Supplies›Supplements & Vitamins›Fish Oil Supplements",
            "Pet Supplies›Cats›Health Supplies›Supplements & Vitamins›Antioxidants",
            "Pet Supplies›Dogs›Health Supplies›Supplements & Vitamins›Amino Acids",
            "Pet Supplies›Dogs›Health Supplies›Supplements & Vitamins›Antioxidants",
            "Pet Supplies›Dogs›Health Supplies›Supplements & Vitamins›Fish Oil Supplements",
            "Pet Supplies›Dogs›Health Supplies›Supplements & Vitamins›Herbal Supplements",
            "Pet Supplies›Dogs›Health Supplies›Supplements & Vitamins›Multivitamins",
            "Pet Supplies›Dogs›Health Supplies›Supplements & Vitamins›Probiotics",
            "Pet Supplies›Horses›Health Supplies›Probiotics & Digestive Supplements",
            "Pet Supplies›Horses›Health Supplies›Vitamins & Supplements›Calming Supplements",
            "Pet Supplies›Horses›Health Supplies›Vitamins & Supplements›Electrolyte Supplements",
            "Pet Supplies›Horses›Health Supplies›Vitamins & Supplements›Skin, Coat & Hoof Supplements",
            "Pet Supplies›Horses›Health Supplies›Vitamins & Supplements›Vitamins & Minerals",
            "Pet Supplies›Horses›Health Supplies›Vitamins & Supplements›Weight Building Supplements",
            "Health & Household›Household Supplies›Household Batteries›12V",
            "Health & Household›Household Supplies›Household Batteries›3.7V",
            "Health & Household›Household Supplies›Household Batteries›3V",
            "Health & Household›Household Supplies›Household Batteries›6V",
            "Health & Household›Household Supplies›Household Batteries›9V",
            "Health & Household›Household Supplies›Household Batteries›A",
            "Health & Household›Household Supplies›Household Batteries›AA",
            "Health & Household›Household Supplies›Household Batteries›AAA",
            "Health & Household›Household Supplies›Household Batteries›AAAA",
            "Health & Household›Household Supplies›Household Batteries›C",
            "Health & Household›Household Supplies›Household Batteries›Coin & Button Cell",
            "Health & Household›Household Supplies›Household Batteries›D",
            "Health & Household›Oral Care›Baby & Child Dental Care›Children's Dental Care›Toothpaste",
            "Health & Household›Oral Care›Baby & Child Dental Care›Children's Dental Care›Mouthwashes",
            "Health & Household›Baby & Child Care›Personal Care›Baby Bubble Bath & Cleansers",
            "Baby Products›Baby Care›Bathing›Conditioners",
            "Baby Products›Baby Care›Bathing›Shampoo",
            "Beauty & Personal Care›Hair Care›Hair Coloring Products›Color Refreshers›Color Conditioners",
            "Beauty & Personal Care›Hair Care›Hair Coloring Products›Color Refreshers›Color Glazes",
            "Beauty & Personal Care›Hair Care›Hair Coloring Products›Color Refreshers›Color Refreshing Masks",
            "Beauty & Personal Care›Hair Care›Hair Coloring Products›Color Removers",
            "Beauty & Personal Care›Hair Care›Hair Coloring Products›Developers",
            "Beauty & Personal Care›Hair Care›Hair Coloring Products›Hair Bleach",
            "Beauty & Personal Care›Hair Care›Hair Coloring Products›Hair Color",
            "Beauty & Personal Care›Hair Care›Hair Coloring Products›Hennas",
            "Beauty & Personal Care›Hair Care›Hair Coloring Products›Highlight Kits",
            "Beauty & Personal Care›Hair Care›Hair Loss Products›Hair Regrowth Conditioners",
            "Beauty & Personal Care›Hair Care›Hair Loss Products›Hair Regrowth Shampoos",
            "Beauty & Personal Care›Hair Care›Hair Loss Products›Hair Regrowth Tonics",
            "Beauty & Personal Care›Hair Care›Hair Loss Products›Hair Regrowth Treatments",
            "Beauty & Personal Care›Hair Care›Shampoo & Conditioner›Deep Conditioners",
            "Beauty & Personal Care›Hair Care›Hair Masks",
            "Beauty & Personal Care›Hair Care›Hair Treatment Oils",
            "Beauty & Personal Care›Hair Care›Shampoo & Conditioner›2-in-1 Shampoo & Conditioner",
            "Beauty & Personal Care›Hair Care›Shampoo & Conditioner›3-in-1 Shampoo, Conditioner & Body Wash",
            "Beauty & Personal Care›Hair Care›Shampoo & Conditioner›Conditioners",
            "Beauty & Personal Care›Hair Care›Shampoo & Conditioner›Dry Shampoos",
            "Beauty & Personal Care›Hair Care›Shampoo & Conditioner›Shampoo & Conditioner Sets",
            "Beauty & Personal Care›Hair Care›Shampoo & Conditioner›Shampoos",
            "Beauty & Personal Care›Hair Care›Styling Products›Creams & Lotions",
            "Beauty & Personal Care›Personal Care›Bath & Bathing Accessories›Bath›Bath Oils",
            "Beauty & Personal Care›Personal Care›Bath & Bathing Accessories›Bath›Bubble Bath",
            "Beauty & Personal Care›Personal Care›Deodorants & Antiperspirants›Antiperspirant Deodorant",
            "Beauty & Personal Care›Personal Care›Deodorants & Antiperspirants›Antiperspirants",
            "Beauty & Personal Care›Personal Care›Deodorants & Antiperspirants›Deodorant",
            "Health & Household›Oral Care›Breath Fresheners",
            "Health & Household›Oral Care›Mouthwash",
            "Health & Household›Oral Care›Toothpaste",
            "Beauty & Personal Care›Skin Care›Body›Body Scrubs",
            "Beauty & Personal Care›Skin Care›Body›Body Mud",
            "Beauty & Personal Care›Skin Care›Body›Cleansers›Body Washes",
            "Beauty & Personal Care›Skin Care›Body›Cleansers›Hand Wash",
            "Beauty & Personal Care›Skin Care›Body›Cleansers›Soaps",
            "Beauty & Personal Care›Skin Care›Face›Polishes & Scrubs›Scrubs",
            "Beauty & Personal Care›Skin Care›Face›Cleansers›Bars",
            "Beauty & Personal Care›Shave & Hair Removal›Men's›After Shaves›Balms",
            "Beauty & Personal Care›Shave & Hair Removal›Men's›After Shaves›Gels",
            "Beauty & Personal Care›Shave & Hair Removal›Men's›After Shaves›Lotions",
            "Health & Household›Health Care›First Aid›Antibiotics & Antiseptics›Hand Sanitizers",
            "Health & Household›Health Care›First Aid›Lice Treatments›Shampoos & Rinses",
            "Health & Household›Health Care›First Aid›Lice Treatments›Sprays",
            "Health & Household›Health Care›First Aid›Lice Treatments›Treatment Packages",
            "Health & Household›Health Care›Insect & Pest Repellents›Body Treatments›Moisturizers",
            "Health & Household›Household Supplies›Dishwashing›Dish Soap",
            "Health & Household›Household Supplies›Household Cleaning›Kitchen Cleaners›Dishwasher & Garbage Disposal Cleaners›Dishwasher Cleaners",
            "Health & Household›Household Supplies›Dishwashing›Dishwasher Detergent",
            "Health & Household›Household Supplies›Dishwashing›Rinse Aids",
            "Health & Household›Household Supplies›Household Cleaning›All-Purpose Cleaners",
            "Health & Household›Household Supplies›Household Cleaning›Bathroom Cleaners›Lime & Rust Removers",
            "Health & Household›Household Supplies›Household Cleaning›Bathroom Cleaners›Mold & Mildew Removers",
            "Health & Household›Household Supplies›Household Cleaning›Bathroom Cleaners›Multipurpose Bathroom Cleaners",
            "Health & Household›Household Supplies›Household Cleaning›Bathroom Cleaners›Soap Scum Removers",
            "Health & Household›Household Supplies›Household Cleaning›Carpet Cleaners›Carpet Machine Detergents",
            "Health & Household›Household Supplies›Household Cleaning›Carpet Cleaners›Carpet Spot Cleaning Sprays",
            "Health & Household›Household Supplies›Household Cleaning›Carpet Cleaners›Carpet Stain Precleaners",
            "Industrial & Scientific›Janitorial & Sanitation Supplies›Cleaning Chemicals›Carpet Deodorizers",
            "Health & Household›Household Supplies›Household Cleaning›Carpet Deodorizers",
            "Health & Household›Household Supplies›Household Cleaning›Disinfectant Sprays & Liquids",
            "Health & Household›Household Supplies›Cleaning Tools›Mopping›Wet & Dry Mops›Dust Mops",
            "Health & Household›Household Supplies›Household Cleaning›Glass Cleaners",
            "Health & Household›Household Supplies›Household Cleaning›Kitchen Cleaners›Cooktop Cleaners",
            "Health & Household›Household Supplies›Household Cleaning›Kitchen Cleaners›Degreasers",
            "Health & Household›Household Supplies›Household Cleaning›Kitchen Cleaners›Dishwasher & Garbage Disposal Cleaners›Garbage Disposal Cleaners",
            "Health & Household›Household Supplies›Household Cleaning›Kitchen Cleaners›Oven & Grill Cleaners",
            "Health & Household›Household Supplies›Household Cleaning›Kitchen Cleaners›Stainless Steel Surface Cleaners",
            "Health & Household›Household Supplies›Household Cleaning›Kitchen Cleaners›Stone Surface Polish & Cleaners",
            "Health & Household›Household Supplies›Household Cleaning›Upholstery Cleaners›Fabric Cleaners",
            "Health & Household›Household Supplies›Household Cleaning›Upholstery Cleaners›Leather Cleaners & Conditioners",
            "Health & Household›Household Supplies›Laundry›Bleach",
            "Health & Household›Household Supplies›Laundry›Fabric Deodorizer",
            "Health & Household›Household Supplies›Laundry›Laundry Detergent›Detergent Pacs & Tablets",
            "Health & Household›Household Supplies›Laundry›Laundry Detergent›Liquid Detergent",
            "Health & Household›Household Supplies›Laundry›Laundry Detergent",
            "Health & Household›Household Supplies›Laundry›Laundry Detergent›Powder Detergent",
            "Health & Household›Household Supplies›Laundry›Liquid Fabric Softener",
            "Health & Household›Household Supplies›Laundry›Stain Removers",
            "Health & Household›Household Supplies›Laundry›Starch & Anti-static Sprays",
            "Health & Household›Household Supplies›Laundry›Washing Machine Cleaners",
            "Health & Household›Oral Care›Dry Mouth Relief",
            "Health & Household›Oral Care›Oral Pain Relief›Rinses",
            "Health & Household›Health Care›Feminine Care›Deodorant Sprays",
            "Health & Household›Health Care›Feminine Care›Feminine Powders",
            "Health & Household›Health Care›Feminine Care›Feminine Washes",
            "Health & Household›Health Care›Women's Health",
            "Baby Products›Baby Care›Bathing›Bubble Bath",
            "Baby Products›Baby Care›Bathing›Soaps & Cleansers›Bar Soaps",
            "Baby Products›Baby Care›Bathing›Soaps & Cleansers›Body Wash",
            "Baby Products›Baby Care›Bathing›Soaps & Cleansers›Foaming Soaps",
            "Baby Products›Baby Care›Bathing›Soaps & Cleansers›No-Rinse Cleansers",
            "Baby Products›Baby Care›Bathing›Travel Bathing Kits",
            "Health & Household›Household Supplies›Household Cleaning›Floor Cleaners",
            "Pet Supplies›Dogs›Health Supplies›Dental Care›Toothpaste",
            "Pet Supplies›Dogs›Grooming›Shampoos & Conditioners›Shampoos",
            "Pet Supplies›Cats›Grooming›Shampoos & Conditioners›Conditioners",
            "Pet Supplies›Cats›Grooming›Shampoos & Conditioners›Shampoos",
            "Pet Supplies›Cats›Grooming›Shampoos & Conditioners›Shampoos Plus Conditioners",
            "Pet Supplies›Dogs›Grooming›Shampoos & Conditioners›Conditioners",
            "Pet Supplies›Dogs›Grooming›Shampoos & Conditioners›Shampoos Plus Conditioners",
            "Beauty & Personal Care›Foot, Hand & Nail Care›Foot & Hand Care›Hand Creams & Lotions",
            "Beauty & Personal Care›Foot, Hand & Nail Care›Foot & Hand Care›Foot Creams & Lotions",
            "Beauty & Personal Care›Foot, Hand & Nail Care›Foot & Hand Care›Foot Masks",
            "Baby Products›Baby Care›Grooming›Skin Care›Lotions",
            "Baby Products›Baby Care›Grooming›Skin Care›Oils",
            "Baby Products›Baby Care›Grooming›Skin Care›Powders",
            "Beauty & Personal Care›Skin Care›Body›Moisturizers›Body Butters",
            "Beauty & Personal Care›Skin Care›Body›Moisturizers›Creams",
            "Beauty & Personal Care›Skin Care›Body›Moisturizers›Lotions",
            "Beauty & Personal Care›Skin Care›Body›Moisturizers›Mousses",
            "Beauty & Personal Care›Skin Care›Body›Moisturizers›Oils",
            "Beauty & Personal Care›Skin Care›Body›Sets & Kits",
            "Beauty & Personal Care›Skin Care›Eyes›Balms",
            "Beauty & Personal Care›Skin Care›Eyes›Creams",
            "Beauty & Personal Care›Skin Care›Eyes›Gels",
            "Beauty & Personal Care›Skin Care›Eyes›Serums",
            "Beauty & Personal Care›Skin Care›Eyes›Wrinkle Pads & Patches",
            "Beauty & Personal Care›Skin Care›Eyes›Masks",
            "Beauty & Personal Care›Skin Care›Face›Creams & Moisturizers›Face Mists",
            "Beauty & Personal Care›Skin Care›Face›Creams & Moisturizers›Face Moisturizers",
            "Beauty & Personal Care›Skin Care›Face›Creams & Moisturizers›Face Oil",
            "Beauty & Personal Care›Skin Care›Face›Creams & Moisturizers›Neck & Décolleté",
            "Beauty & Personal Care›Skin Care›Face›Creams & Moisturizers›Night Creams",
            "Beauty & Personal Care›Skin Care›Face›Facial Kits",
            "Beauty & Personal Care›Skin Care›Face›Toners & Astringents",
            "Beauty & Personal Care›Skin Care›Face›Treatments & Masks›Serums",
            "Beauty & Personal Care›Skin Care›Face›Treatments & Masks›Masks",
            "Beauty & Personal Care›Skin Care›Face›Polishes & Scrubs›Polishes",
            "Beauty & Personal Care›Skin Care›Maternity",
            "Beauty & Personal Care›Skin Care›Face›Treatments & Masks",
            "Beauty & Personal Care›Foot, Hand & Nail Care›Nail Art & Polish›Nail Polish",
            "Beauty & Personal Care›Foot, Hand & Nail Care›Nail Care›Nail Strengthening",
            "Baby Products›Baby Care›Grooming›Skin Care›Lip Balms",
            "Beauty & Personal Care›Foot, Hand & Nail Care›Nail Art & Polish›Base & Top Coats›Base Coat",
            "Beauty & Personal Care›Foot, Hand & Nail Care›Nail Art & Polish›Base & Top Coats›Combination Base & Top Coats",
            "Beauty & Personal Care›Foot, Hand & Nail Care›Nail Art & Polish›Dip Manicure›Dip Powder Liquids",
            "Beauty & Personal Care›Foot, Hand & Nail Care›Nail Art & Polish›Nail Thickening Solution",
            "Beauty & Personal Care›Foot, Hand & Nail Care›Nail Care›Cuticle Care›Cuticle Oils",
            "Beauty & Personal Care›Foot, Hand & Nail Care›Nail Care›Cuticle Care›Cuticle Removing Fluids",
            "Beauty & Personal Care›Foot, Hand & Nail Care›Nail Care›Growth Formula",
            "Beauty & Personal Care›Fragrance›Children's",
            "Beauty & Personal Care›Fragrance›Dusting Powders",
            "Beauty & Personal Care›Fragrance›Men's›Body Sprays",
            "Beauty & Personal Care›Fragrance›Men's›Cologne",
            "Beauty & Personal Care›Fragrance›Men's›Eau Fraiche",
            "Beauty & Personal Care›Fragrance›Men's›Eau de Parfum",
            "Beauty & Personal Care›Fragrance›Men's›Eau de Toilette",
            "Beauty & Personal Care›Fragrance›Men's›Sets",
            "Beauty & Personal Care›Fragrance›Women's›Sets",
            "Beauty & Personal Care›Hair Care›Hair Coloring Products›Hair Mascaras & Root Touch Ups",
            "Beauty & Personal Care›Hair Care›Hair Fragrances",
            "Beauty & Personal Care›Makeup›Body›Bronzers",
            "Beauty & Personal Care›Makeup›Body›Concealer",
            "Beauty & Personal Care›Makeup›Body›Temporary Tattoos",
            "Beauty & Personal Care›Makeup›Eyes›Concealer",
            "Beauty & Personal Care›Makeup›Eyes›Eyebrow Color",
            "Beauty & Personal Care›Makeup›Eyes›Eyelash Primers",
            "Beauty & Personal Care›Makeup›Eyes›Eyeliner",
            "Beauty & Personal Care›Makeup›Eyes›Eyeshadow",
            "Beauty & Personal Care›Makeup›Eyes›Eyeshadow Bases & Primers",
            "Beauty & Personal Care›Makeup›Eyes›Liner & Shadow Combinations",
            "Beauty & Personal Care›Makeup›Eyes›Mascara",
            "Beauty & Personal Care›Makeup›Face›BB Creams",
            "Beauty & Personal Care›Makeup›Face›Blush",
            "Beauty & Personal Care›Makeup›Face›Bronzers",
            "Beauty & Personal Care›Makeup›Face›CC Creams",
            "Beauty & Personal Care›Makeup›Face›Concealers & Neutralizers",
            "Beauty & Personal Care›Makeup›Face›DD Creams",
            "Beauty & Personal Care›Makeup›Face›Foundation",
            "Beauty & Personal Care›Makeup›Face›Foundation Primers",
            "Beauty & Personal Care›Makeup›Face›Highlighters & Luminizers",
            "Beauty & Personal Care›Makeup›Face›Powder",
            "Beauty & Personal Care›Makeup›Face›Tinted Moisturizers",
            "Beauty & Personal Care›Makeup›Lips›Lip Glosses",
            "Beauty & Personal Care›Makeup›Lips›Lip Liners",
            "Beauty & Personal Care›Makeup›Lips›Lip Stains",
            "Beauty & Personal Care›Makeup›Lips›Lipstick",
            "Beauty & Personal Care›Makeup›Lips›Lipstick Primers",
            "Beauty & Personal Care›Makeup›Makeup Palettes",
            "Beauty & Personal Care›Makeup›Makeup Remover›Makeup Cleansing Creams",
            "Beauty & Personal Care›Makeup›Makeup Remover›Makeup Cleansing Foams",
            "Beauty & Personal Care›Makeup›Makeup Remover›Makeup Cleansing Gels",
            "Beauty & Personal Care›Makeup›Makeup Remover›Makeup Cleansing Milk",
            "Beauty & Personal Care›Makeup›Makeup Remover›Makeup Cleansing Oils",
            "Beauty & Personal Care›Makeup›Makeup Remover›Makeup Cleansing Water",
            "Beauty & Personal Care›Makeup›Makeup Remover›Makeup Cleansing Wipes",
            "Beauty & Personal Care›Makeup›Makeup Sets",
            "Beauty & Personal Care›Skin Care›Lip Care›Balms & Moisturizers",
            "Beauty & Personal Care›Skin Care›Lip Care›Lip Butters",
            "Beauty & Personal Care›Skin Care›Lip Care›Lip Plumpers",
            "Beauty & Personal Care›Skin Care›Lip Care›Scrubs",
            "Beauty & Personal Care›Personal Care›Scrubs & Body Treatments",
            "Beauty & Personal Care›Skin Care›Sunscreens & Tanning Products›Self-Tanners›Body Self-Tanners",
            "Beauty & Personal Care›Skin Care›Sunscreens & Tanning Products›After Sun",
            "Beauty & Personal Care›Skin Care›Sunscreens & Tanning Products›Self-Tanners›Facial Self Tanners",
            "Beauty & Personal Care›Skin Care›Sunscreens & Tanning Products›Sunscreens›Body Sunscreens",
            "Beauty & Personal Care›Skin Care›Sunscreens & Tanning Products›Sunscreens›Facial Sunscreens",
            "Beauty & Personal Care›Skin Care›Sunscreens & Tanning Products›Sunscreens›Lip Sunscreens",
            "Beauty & Personal Care›Skin Care›Sunscreens & Tanning Products›Tanning Oils & Lotions",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Healthy Snacks & Beverages›Chips & Crisps",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Healthy Snacks & Beverages›Chocolate & Carob",
            "Grocery & Gourmet Food›Breads & Bakery›Cookies",
            "Pet Supplies›Birds›Food",
            "Pet Supplies›Birds›Treats",
            "Pet Supplies›Cats›Food›Dehydrated",
            "Pet Supplies›Cats›Food›Dry",
            "Pet Supplies›Cats›Food›Food Toppers",
            "Pet Supplies›Cats›Food›Freeze-Dried",
            "Pet Supplies›Cats›Food›Frozen",
            "Pet Supplies›Cats›Health Supplies›Milk Replacers",
            "Pet Supplies›Cats›Food›Veterinary Diets",
            "Pet Supplies›Cats›Food›Wet›Canned",
            "Pet Supplies›Cats›Food›Wet›Pouches",
            "Pet Supplies›Cats›Treats›Catnip",
            "Pet Supplies›Cats›Treats›Pastes",
            "Pet Supplies›Cats›Treats›Snacks›Crunchy Treats",
            "Pet Supplies›Cats›Treats›Snacks›Soft Treats",
            "Pet Supplies›Dogs›Food›Dehydrated",
            "Pet Supplies›Dogs›Food›Dry",
            "Pet Supplies›Dogs›Food›Food Toppers",
            "Pet Supplies›Dogs›Food›Freeze-Dried",
            "Pet Supplies›Dogs›Food›Frozen",
            "Pet Supplies›Dogs›Food›Semi-Moist",
            "Pet Supplies›Dogs›Food›Veterinary Diets",
            "Pet Supplies›Dogs›Food›Wet›Canned",
            "Pet Supplies›Dogs›Food›Wet›Pouches",
            "Pet Supplies›Dogs›Food›Wet›Rolls",
            "Pet Supplies›Dogs›Treats›Animal Ears›Cow Ears",
            "Pet Supplies›Dogs›Treats›Animal Ears›Lamb Ears",
            "Pet Supplies›Dogs›Treats›Animal Ears›Pig Ears",
            "Pet Supplies›Dogs›Treats›Bones",
            "Pet Supplies›Dogs›Treats›Bully Sticks",
            "Pet Supplies›Dogs›Treats›Cookies, Biscuits & Snacks",
            "Pet Supplies›Dogs›Treats›Hooves",
            "Pet Supplies›Dogs›Treats›Jerky",
            "Pet Supplies›Dogs›Treats›Rawhide›Bones",
            "Pet Supplies›Dogs›Treats›Rawhide›Chips",
            "Pet Supplies›Dogs›Treats›Rawhide›Rolls",
            "Pet Supplies›Dogs›Treats›Rawhide›Sticks & Twists",
            "Pet Supplies›Fish & Aquatic Pets›Food›Aquarium Fish",
            "Pet Supplies›Horses›Food",
            "Pet Supplies›Horses›Treats",
            "Pet Supplies›Reptiles & Amphibians›Food",
            "Pet Supplies›Small Animals›Food",
            "Pet Supplies›Small Animals›Treats",
            "Baby Products›Feeding›Baby Foods›Beverages›Electrolyte Drinks",
            "Baby Products›Feeding›Baby Foods›Beverages›Juices",
            "Baby Products›Feeding›Baby Foods›Beverages›Nutritional Shakes",
            "Baby Products›Feeding›Baby Foods›Beverages›Smoothies",
            "Grocery & Gourmet Food›Beverages›Tea›Fruit & Herbal Tea›Herbal",
            "Baby Products›Feeding›Baby Foods›Cereal & Porridge›Cereal",
            "Baby Products›Feeding›Baby Foods›Cereal & Porridge›Porridge",
            "Baby Products›Feeding›Baby Foods›Formula›Liquid Baby Formula",
            "Baby Products›Feeding›Baby Foods›Formula›Powder Baby Formula",
            "Baby Products›Feeding›Baby Foods›Meals",
            "Baby Products›Feeding›Baby Foods›Snack Foods",
            "Patio, Lawn & Garden›Backyard Birding & Wildlife›Birds›Food›Hummingbird Nectar",
            "Health & Household›Diet & Sports Nutrition›Sports Nutrition›Healthy Snacks & Beverages›Pudding",
            "Patio, Lawn & Garden›Gardening & Lawn Care›Plants, Seeds & Bulbs›Aquatic Plants",
            "Patio, Lawn & Garden›Gardening & Lawn Care›Plants, Seeds & Bulbs›Bonsai",
            "Patio, Lawn & Garden›Gardening & Lawn Care›Plants, Seeds & Bulbs›Cacti & Succulents",
            "Patio, Lawn & Garden›Gardening & Lawn Care›Plants, Seeds & Bulbs›Flowers",
            "Patio, Lawn & Garden›Gardening & Lawn Care›Plants, Seeds & Bulbs›Fruits",
            "Patio, Lawn & Garden›Gardening & Lawn Care›Plants, Seeds & Bulbs›Grasses",
            "Patio, Lawn & Garden›Gardening & Lawn Care›Plants, Seeds & Bulbs›Hedges & Shrubs",
            "Patio, Lawn & Garden›Gardening & Lawn Care›Plants, Seeds & Bulbs›Herbs",
            "Patio, Lawn & Garden›Gardening & Lawn Care›Plants, Seeds & Bulbs›Trees",
            "Patio, Lawn & Garden›Gardening & Lawn Care›Plants, Seeds & Bulbs›Vegetables",
            "Patio, Lawn & Garden›Gardening & Lawn Care›Plants, Seeds & Bulbs›Vines",
            "Clothing, Shoes & Jewelry›Baby›Baby Boys›Shoes›Athletic & Outdoor",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Sandals",
            "Clothing, Shoes & Jewelry›Baby›Baby Girls›Shoes›Athletic & Outdoor",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Sandals",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Baseball & Softball",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Basketball",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Bowling",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Dance",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Equestrian Sport Boots",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Fitness & Cross-Training",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Football",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Handball",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Racquet Sports",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Running",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Skateboarding",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Soccer",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Sport Sandals",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Trail Running",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Walking",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Athletic›Water Shoes",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Clogs & Mules",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Boots",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Loafers",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Oxfords",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Slippers",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Sneakers",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Outdoor›Hiking & Trekking›Hiking Boots",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Outdoor›Hiking & Trekking›Hiking Boots",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Outdoor›Hiking & Trekking›Hiking Shoes",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Outdoor›Rain Boots",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Outdoor›Snow Boots",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Outdoor›Sport Sandals",
            "Clothing, Shoes & Jewelry›Boys›Shoes›Outdoor›Water Shoes",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Basketball",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Bowling",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Dance",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Equestrian Sport Boots",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Fitness & Cross-Training",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Racquet Sports",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Running",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Skateboarding",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Soccer",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Sport Sandals",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Trail Running",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Walking",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Water Shoes",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Athletic›Cheerleading",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Boots",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Clogs & Mules",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Flats",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Loafers",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Oxfords",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Slippers",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Sneakers",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Pumps",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Outdoor›Rain Boots",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Outdoor›Snow Boots",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Outdoor›Sport Sandals",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Outdoor›Water Shoes",
            "Clothing, Shoes & Jewelry›Girls›Shoes›Outdoor›Trail Running",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Ballet & Dance",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Cycling",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Equestrian Sport Boots",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Fitness & Cross-Training",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Golf",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Running›Road Running",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Running›Track & Field & Cross Country",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Running›Trail Running",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Skateboarding",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Sport Sandals & Slides",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Team Sports›Baseball & Softball",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Team Sports›Basketball",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Team Sports›Football",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Team Sports›Rugby",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Team Sports›Soccer",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Team Sports›Volleyball",
            "Clothing, Shoes & Jewelry›Men›Shoes›Athletic›Team Sports›Field Hockey & Lacrosse",
            "Clothing, Shoes & Jewelry›Men›Shoes›Fashion Sneakers",
            "Clothing, Shoes & Jewelry›Men›Shoes›Loafers & Slip-Ons",
            "Clothing, Shoes & Jewelry›Men›Shoes›Mules & Clogs",
            "Clothing, Shoes & Jewelry›Men›Shoes›Boots›Chelsea",
            "Clothing, Shoes & Jewelry›Men›Shoes›Boots›Chukka",
            "Clothing, Shoes & Jewelry›Men›Shoes›Boots›Hiking Boots",
            "Clothing, Shoes & Jewelry›Men›Shoes›Boots›Hunting",
            "Clothing, Shoes & Jewelry›Men›Shoes›Boots›Motorcycle & Combat",
            "Clothing, Shoes & Jewelry›Men›Shoes›Boots›Oxford & Derby",
            "Clothing, Shoes & Jewelry›Men›Shoes›Boots›Rain",
            "Clothing, Shoes & Jewelry›Men›Shoes›Boots›Snow Boots",
            "Clothing, Shoes & Jewelry›Men›Shoes›Boots›Western",
            "Clothing, Shoes & Jewelry›Men›Uniforms, Work & Safety›Shoes›Work & Utility›Shoes",
            "Clothing, Shoes & Jewelry›Men›Uniforms, Work & Safety›Shoes›Work & Utility›Industrial & Construction Boots",
            "Clothing, Shoes & Jewelry›Men›Uniforms, Work & Safety›Shoes›Military & Tactical",
            "Clothing, Shoes & Jewelry›Men›Shoes›Boots",
            "Clothing, Shoes & Jewelry›Men›Shoes›Outdoor›Climbing",
            "Clothing, Shoes & Jewelry›Men›Shoes›Outdoor›Hiking & Trekking›Backpacking Boots",
            "Clothing, Shoes & Jewelry›Men›Shoes›Outdoor›Hiking & Trekking›Hiking Boots",
            "Clothing, Shoes & Jewelry›Men›Shoes›Outdoor›Hiking & Trekking›Hiking Shoes",
            "Clothing, Shoes & Jewelry›Men›Shoes›Outdoor›Hiking & Trekking›Mountaineering Boots",
            "Clothing, Shoes & Jewelry›Men›Shoes›Outdoor›Hunting",
            "Clothing, Shoes & Jewelry›Men›Shoes›Outdoor›Snow Boots",
            "Clothing, Shoes & Jewelry›Men›Shoes›Outdoor›Sport Sandals & Slides",
            "Clothing, Shoes & Jewelry›Men›Shoes›Outdoor›Trail Running",
            "Clothing, Shoes & Jewelry›Men›Shoes›Outdoor›Water Shoes",
            "Clothing, Shoes & Jewelry›Men›Shoes›Oxfords",
            "Clothing, Shoes & Jewelry›Men›Shoes›Sandals",
            "Clothing, Shoes & Jewelry›Women›Uniforms, Work & Safety›Shoes›Work & Utility›Boots",
            "Clothing, Shoes & Jewelry›Men›Uniforms, Work & Safety›Shoes›Fire & Safety",
            "Clothing, Shoes & Jewelry›Men›Uniforms, Work & Safety›Shoes›Health Care & Food Service",
            "Clothing, Shoes & Jewelry›Men›Uniforms, Work & Safety›Shoes›Uniform Dress Shoes",
            "Clothing, Shoes & Jewelry›Men›Shoes›Slippers",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Bowling",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Ballet & Dance",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Cycling",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Equestrian Sport Boots",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Fitness & Cross-Training",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Golf",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Running›Road Running",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Running›Track & Field & Cross Country",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Running›Trail Running",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Skateboarding",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Sport Sandals & Slides",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Team Sports›Softball & Baseball",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Team Sports›Basketball",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Team Sports›Soccer",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Team Sports›Volleyball",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Team Sports›Field Hockey & Lacrosse",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Tennis & Racquet Sports",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Walking",
            "Clothing, Shoes & Jewelry›Women›Shoes›Athletic›Water Shoes",
            "Clothing, Shoes & Jewelry›Women›Shoes›Boots›Ankle & Bootie",
            "Clothing, Shoes & Jewelry›Women›Shoes›Boots›Knee-High",
            "Clothing, Shoes & Jewelry›Women›Shoes›Boots›Mid-Calf",
            "Clothing, Shoes & Jewelry›Women›Shoes›Boots›Over-the-Knee",
            "Clothing, Shoes & Jewelry›Women›Shoes›Flats",
            "Clothing, Shoes & Jewelry›Women›Shoes›Fashion Sneakers",
            "Clothing, Shoes & Jewelry›Women›Shoes›Loafers & Slip-Ons",
            "Clothing, Shoes & Jewelry›Women›Shoes›Mules & Clogs",
            "Clothing, Shoes & Jewelry›Women›Shoes›Outdoor›Climbing",
            "Clothing, Shoes & Jewelry›Women›Shoes›Outdoor›Hiking & Trekking›Backpacking Boots",
            "Clothing, Shoes & Jewelry›Women›Shoes›Outdoor›Hiking & Trekking›Hiking Boots",
            "Clothing, Shoes & Jewelry›Women›Shoes›Outdoor›Hiking & Trekking›Hiking Shoes",
            "Clothing, Shoes & Jewelry›Women›Shoes›Outdoor›Hiking & Trekking›Mountaineering Boots",
            "Clothing, Shoes & Jewelry›Women›Shoes›Outdoor›Hunting",
            "Clothing, Shoes & Jewelry›Women›Shoes›Outdoor›Rain Footwear",
            "Clothing, Shoes & Jewelry›Women›Shoes›Outdoor›Snow Boots",
            "Clothing, Shoes & Jewelry›Women›Shoes›Outdoor›Sport Sandals & Slides",
            "Clothing, Shoes & Jewelry›Women›Shoes›Outdoor›Trail Running",
            "Clothing, Shoes & Jewelry›Women›Shoes›Outdoor›Water Shoes",
            "Clothing, Shoes & Jewelry›Women›Shoes›Oxfords",
            "Clothing, Shoes & Jewelry›Women›Shoes›Slippers",
            "Clothing, Shoes & Jewelry›Women›Shoes›Pumps",
            "Clothing, Shoes & Jewelry›Women›Shoes›Sandals›Flats",
            "Clothing, Shoes & Jewelry›Women›Shoes›Sandals›Flip-Flops",
            "Clothing, Shoes & Jewelry›Women›Shoes›Sandals›Heeled Sandals",
            "Clothing, Shoes & Jewelry›Women›Shoes›Sandals›Platforms & Wedges",
            "Clothing, Shoes & Jewelry›Women›Shoes›Sandals›Slides",
            "Clothing, Shoes & Jewelry›Women›Uniforms, Work & Safety›Shoes›Fire & Safety",
            "Clothing, Shoes & Jewelry›Women›Uniforms, Work & Safety›Shoes›Health Care & Food Service",
            "Clothing, Shoes & Jewelry›Women›Uniforms, Work & Safety›Shoes›Military & Tactical",
            "Clothing, Shoes & Jewelry›Women›Uniforms, Work & Safety›Shoes›Uniform Dress Shoes",
            "Clothing, Shoes & Jewelry›Women›Uniforms, Work & Safety›Shoes›Work & Utility›Shoes",
            "Clothing, Shoes & Jewelry›Women›Uniforms, Work & Safety›Shoes›Work & Utility›Industrial & Construction Boots",
            "Clothing, Shoes & Jewelry›Women›Shoes›Boots",
            "Clothing, Shoes & Jewelry›Women›Shoes",
            "Automotive›Oils & Fluids›Additives›Cooling System",
            "Automotive›Oils & Fluids›Additives›Engine & Oil",
            "Automotive›Oils & Fluids›Additives›Fuel System›Diesel Additives",
            "Automotive›Oils & Fluids›Additives›Fuel System›Fuel Additives",
            "Automotive›Oils & Fluids›Additives›Fuel System›Octane Boosters",
            "Automotive›Oils & Fluids›Additives›Hydraulic",
            "Automotive›Oils & Fluids›Additives›Power Steering",
            "Automotive›Oils & Fluids›Additives›Transmission",
            "Automotive›Oils & Fluids›Antifreezes & Coolants",
            "Automotive›Oils & Fluids›Brake Fluids",
            "Automotive›Oils & Fluids›Cleaners›Brake Cleaners",
            "Automotive›Oils & Fluids›Cleaners›Carburetor & Throttle Body Cleaners",
            "Automotive›Oils & Fluids›Cleaners›Electrical Cleaners",
            "Automotive›Oils & Fluids›Cleaners›Engine Cleaners & Degreasers›Degreasers",
            "Automotive›Oils & Fluids›Cleaners›Engine Cleaners & Degreasers›Engine Cleaner Foams",
            "Automotive›Oils & Fluids›Cleaners›Engine Cleaners & Degreasers›Engine Cleaner Sprays",
            "Automotive›Oils & Fluids›Cleaners›Fan Belt Dressings",
            "Automotive›Oils & Fluids›Cleaners›Fuel System Cleaners",
            "Automotive›Oils & Fluids›Greases & Lubricants›Greases›Brake Quiet",
            "Automotive›Oils & Fluids›Greases & Lubricants›Greases›Caliper",
            "Automotive›Oils & Fluids›Greases & Lubricants›Greases›Electrical",
            "Automotive›Oils & Fluids›Greases & Lubricants›Greases›Lithium",
            "Automotive›Oils & Fluids›Greases & Lubricants›Greases›Moly",
            "Automotive›Oils & Fluids›Greases & Lubricants›Greases›Wheel Bearing",
            "Automotive›Oils & Fluids›Greases & Lubricants›Lubricants›Anti-Seize",
            "Automotive›Oils & Fluids›Greases & Lubricants›Lubricants›Assembly",
            "Automotive›Oils & Fluids›Greases & Lubricants›Lubricants›Electrical",
            "Automotive›Oils & Fluids›Greases & Lubricants›Lubricants›Graphite",
            "Automotive›Heavy Duty & Commercial Vehicle Equipment›Heavy Duty Oils & Fluids›Antifreeze, Coolant & Diesel Exhaust Fluid",
            "Automotive›Heavy Duty & Commercial Vehicle Equipment›Heavy Duty Oils & Fluids›Heavy Duty Greases & Lubricants",
            "Automotive›Heavy Duty & Commercial Vehicle Equipment›Heavy Duty Oils & Fluids›Heavy Duty Oils",
            "Automotive›Oils & Fluids›Oils›Air Conditioning Oils",
            "Automotive›Oils & Fluids›Oils›Gear Oils",
            "Automotive›Oils & Fluids›Oils›Hydraulic Oils",
            "Automotive›Oils & Fluids›Oils›Motor Oils",
            "Automotive›Oils & Fluids›Power Steering Fluids",
            "Automotive›Oils & Fluids›Radiator Conditioners & Protectants",
            "Automotive›Oils & Fluids›Refrigerants",
            "Automotive›Oils & Fluids›Transmission Fluids",
            "Automotive›Oils & Fluids›Windshield Washer Fluids",
            "Health & Household›Vision›Contact Lens Care›Soaking Solutions"
            )
        )
          and (category_id not in ('16025581','16225031','16025611','16026861','16025631','16025641','21579654011',
        '21579651011','21579652011','3762651','3779921','3763031','11062301','3762791','3762931','3762951','3760991',
        '3761041','3761131','3761161','3761171','3761311','3761321','3761281','3761291','3762061','3762091','3762261',
        '13105921','3762181','10728461','3763571','3763611','3763691','3763781','15316491','3763911','3764011','3764031',
        '3764041','10728261','3764131','23675625011','3764411','2975290011','2975293011','204337593011','7214035011',
        '2975288011','3024155011','2975279011','2975278011','2975277011','2975295011','2975381011','2975382011',
        '2975383011','3024218011','2975393011','2975394011','7214034011','204337591011','2975396011','13279221',
        '13279231','204337589011','19163264011','8399172011','2975399011','3024163011','6973671011','7475606011',
        '6973673011','6973677011','6973675011','6973678011','7090302011','7090289011','6973705011','6939082011',
        '6990032011','3773791','3773111','6939949011','3773431','6939950011','6939952011','6940111011','3774981',
        '6973694011','6939045011','6973681011','6973701011','6973698011','6973699011','6973708011','6973710011','6973712011',
        '6973713011','6973715011','6973716011','6973719011','6973717011','6973724011','6973725011','3774941','6939043011','23675621011',
        '6939041011','3762131','3775101','3774531','23675628011','6939046011','6939048011','13106291','3779611','6939977011','3774551',
        '3773341','3774561','3774341','3774331','6940025011','3773461','3774621','3774591','3774601','6966319011','6939030011','6939031011',
        '6939032011','3765801','3774141','3773931','3773401','6940076011','3773701','3774321','3773121','6942465011','6942484011','3773301',
        '3773521','3773531','3773921','6943344011','17382009011','3773501','3773481','6943345011','10728501','6943346011','6943347011',
        '3773841','6943351011','10728601','6943349011','6943350011','3773641','3773651','3773671','3773681','3764481','3774411','23777912011',
        '23777907011','3764561','23777928011','3764621','23777932011','23777917011','3764761','23777924011','23777918011','3765151','3765181',
        '6966317011','6966318011','3765271','23777929011','3765481','3765501','23777909011','3765551','3765611','3765381','3764701','3765511',
        '3765651','23777913011','3765691','3765701','3765711','3765771','23777920011','3765851','23777908011','23777926011','3765901',
        '23777906011','3765951','23777905011','3766101','3766181','23777914011','6966320011','3766301','23777922011','3766261','3766351',
        '23777925011','3766471','3766481','23777911011','3766501','3766541','3766561','23777923011','23777921011','3774101','23777910011',
        '3766821','23777931011','3766921','23777915011','23777916011','23777927011','23777930011','6966321011','3767061','3767051','3767171',
        '23777919011','3767181','3767191','3767221','23777904011','3767451','6944336011','6939007011','3773831','17382011011','3773901',
        '3774291','3774301','3774351','3774381','3774401','3774421','3774431','3774451','3774471','3774481','3774491','3774501','3774511',
        '3774151','23675624011','3774861','6936725011','3774661','3774771','3774781','3774791','3774801','3774761','3774681','3774741',
        '3774691','3774701','3774721','3774711','3774751','6936786011','3774731','3024167011','3024166011','3024165011','3024164011',
        '3024162011','3024216011','3024217011','3024219011','3024220011','3024221011','3024222011','8399165011','8399168011','8399170011',
        '8399174011','8399176011','8399178011','389574011','10112773011','10112775011','389575011','389576011','389662011','389577011',
        '389578011','389579011','389580011','389581011','389582011','13213840011','13213844011','16023581','16027271','166739011',
        '23623517011','10676302011','23623516011','3784201','10676347011','10676353011','10728531','3781641','23623506011','16262042011',
        '16262041011','16262044011','11057581','17911767011','10666437011','10666439011','17911765011','17911766011','11057251',
        '10656664011','11057441','11057651','23623512011','11056261','11056241','702372011','702370011','702371011','3777911','3778161',
        '3778371','11056471','11056441','11056291','11062271','11056341','11061161','7730189011','23673202011','23673203011','23673204011',
        '2265897011','3763081','3763071','3763091','23537020011','15342851','15524347011','15693671','17419395011','15356141','15524334011',
        '15524335011','15524333011','15524336011','14163030011','14163029011','3743601','23870404011','3743581','21579649011','23537023011',
        '15356151','15524343011','15524344011','15524346011','15524351011','15524350011','15524349011','15524352011','15524353011',
        '15342941','15356201','14529075011','15342931','17572415011','15342921','21596702011','15356211','15342951','15524362011',
        '14255252011','10728271','3779521','3779571','13226755011','386373011','322259011','1253811011','668889011','322260011','322262011',
        '723031011','15342861','2975380011','2975374011','3024150011','3024151011','3024152011','2975373011','3024209011','11062261',
        '3780041','17701648011','322264011','322265011','322266011','11060671','11060681','14024031','11056481','11060691','11056581',
        '7730087011','7730090011','7730092011','7730098011','7730099011','11061971','15239989011','16479981011','7792527011','7792277011',
        '7792275011','7792636011','11061931','7792528011','11061121','11061151','11062371','11062031','11059321','11062331','17720267011',
        '17269952011','11059361','21579731011','3782871','19171614011','11062241','11062311','11056711','10292709011','16262034011',
        '11059721','16262035011','363235011','363236011','11059741','11057111','10676359011','10664377011','11058311','11058321',
        '702384011','16228107011','11058451','10312668011','11058521','11058361','16228108011','11058381','11058611','7792268011',
        '11058711','21190479011','7792269011','11058791','7792270011','11058871','388109011','21190478011','11058971','7792276011',
        '11059041','11059101','11059051','11059111','11059221','2265896011','23504931011','23504932011','23504933011','23504929011',
        '23504928011','23504934011','23504930011','11059301','979546011','18065339011','21212387011','979548011','11056421','21388129011',
        '11062601','7792568011','15239990011','7792567011','11062691','11062731','6973685011','6973686011','18774312011','2975238011',
        '3024125011','6514361011','2975266011','6514363011','6514362011','7239526011','2975291011','17044955011','6514357011','6514358011',
        '2975310011','116011808011','116011810011','116011811011','6514321011','2975360011','6514323011','6514322011','7239525011',
        '116011806011','17044954011','6514317011','6514318011','6514319011','3024235011','3024236011','3024237011','2975435011','18198680011',
        '2975436011','2975438011','2975439011','3024241011','3024242011','3024243011','3024244011','116011807011','3085142011','3085136011',
        '2975505011','2975528011','3048877011','21401513011','21401510011','21401514011','21401511011','16318511','16323151','23983647011',
        '21401509011','21401508011','14804133011','6520541011','13402001','6973691011','13402031','10825941','3745941','3749091','3564019011',
        '3751361','13349841','3748321','3752061','3564020011','3564021011','8947928011','3420714011','8947910011','3420855011','3420512011',
        '3420515011','3420519011','3420525011','3420526011','3420523011','3420530011','3420534011','3420542011','3420550011','3420552011',
        '3420554011','3420555011','3420551011','3420560011','3420561011','3420708011','3420707011','3420712011','3420713011','3420716011',
        '3420717011','3420808011','3420537011','3420538011','3420547011','5658906011','3420555011','3420561011','3420787011','3420791011',
        '3420796011','3420797011','3420794011','3420813011','3420821011','3420823011','3420825011','3420826011','3420822011','3420831011',
        '3420832011','3420792011','3420847011','3420848011','3420851011','3420853011','3420854011','3420856011','3420857011','4531947011',
        '3420818011','5658905011','3420826011','3420832011','3420822011','679273011','679272011','3420978011','679271011','679278011',
        '14210389011','3420973011','1264575011','679295011','679291011','679257011','679260011','679275011','683179011','679296011',
        '679302011','3420960011','679312011','679313011','3420996011','11721157011','11721158011','679280011','679283011',
        '11721160011','11721163011','679266011','5658904011','11721159011','679334011','11751044011','6796862011','679307011','679270011',
        '3420956011','679280011','679282011','679281011','679283011','5658904011','679291011','1264575011','679304011','679319011',
        '679320011','23721054011','6796859011','6796861011','6796863011','679324011','679348011','679339011','679352011','3412260011',
        '679351011','679353011','14210388011','3412255011','1264582011','679369011','679365011','679340011','679341011','679370011',
        '679376011','3412242011','3412245011','679377011','679378011','11721153011','11721155011','11721154011','11721156011','679399011',
        '679394011','679404011','679410011','679350011','3412238011','679355011','679357011','679356011','679358011','3412250011',
        '5658903011','679365011','1264582011','679378011','679415011','679433011','679416011','10509644011','10509645011','10509650011',
        '10509646011','10509649011','6796864011','6796865011','6796867011','6796868011','679337011','11751044011','679380011','679337011',
        '15718811','15718821','15718841','15718851','15718861','15718871','15718881','15718891','15718901','15718941','15718981',
        '15718991','15719001','23873692011','23873691011','23873690011','15719021','15719031','15719201','15719221','15719231','15719241',
        '15719251','15719261','15719281','15719291','15719311','15719321','15682256011','15682257011','15682258011','15719341','15719351',
        '15719381','15719391','15719541','15719551','15719561','15719641','15719651','3779711'))
        """
        self.df_flow_asin = self.spark.sql(sqlQuery=sql1).repartition(40, 'account_name').cache()
        print("df_flow_asin数据如下：")
        self.df_flow_asin.show(10, truncate=True)

        # 读取店铺月数据
        sql2 = f"""
        select 
            account_name, 
            seller_id, 
            fb_country_name, 
            business_addr 
        from dwt_fb_base_report
        where site_name = '{self.site_name}' 
          and date_type = '{self.date_type}' 
          and date_info = '{self.date_info}' 
        """
        self.df_fb_info = self.spark.sql(sqlQuery=sql2).repartition(40, 'account_name').cache()
        print("df_fb_info数据如下：")
        self.df_fb_info.show(10, truncate=True)

    def handle_data(self):
        self.df_save = self.df_flow_asin.join(
            self.df_fb_info, on='account_name', how='left'
        ).select(
            "site_name", "asin", F.col("asin_weight").alias("weight"), F.col("asin_bought_month").alias("bought_month"),
            F.col("asin_category_desc").alias("category"), F.col("asin_img_url").alias("img"), F.col("asin_title").alias("title"),
            F.col("asin_brand_name").alias("brand"), "account_name", F.col("business_addr").alias("account_addr"),
            F.col("asin_buy_box_seller_type").alias("buy_box_seller_type"), F.col("asin_launch_time").alias("launch_time"),
            F.col("asin_img_num").alias("img_num"), "variation_flag", "variation_num", F.col("asin_ao_val").alias("ao_val"),
            F.col("category_first_id").alias("category_id"), F.col("category_id").alias("category_current_id"), "parent_asin",
            F.col("first_category_rank").alias("bsr_rank"), F.col("asin_price").alias("price"), F.col("asin_rating").alias("rating"),
            F.col("asin_total_comments").alias("total_comments"), "seller_id", "fb_country_name"
        ).repartition(40, 'asin')

    def save_data(self):
        con_info = DBUtil.get_connection_info('postgresql', 'us')
        table_name = f'ai_asin_detail_month_{self.date_info.replace("-", "_")}'
        self.df_save.write.format("jdbc") \
            .option("url", con_info["url"]) \
            .option("dbtable", table_name) \
            .option("user", con_info["username"]) \
            .option("password", con_info["pwd"]) \
            .mode("append") \
            .save()


if __name__ == "__main__":
    site_name = sys.argv[1]
    date_type = sys.argv[2]
    date_info = sys.argv[3]
    handle_obj = ExportAsinDetailBase(site_name=site_name, date_type=date_type, date_info=date_info)
    handle_obj.run()
