import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil
from utils.db_util import DBUtil

if __name__ == '__main__':
    # 获取入参
    site_name = 'us'
    date_type = 'month'
    date_info = '2023-12'
    db_type = 'postgresql_cluster'
    engine = DBUtil.get_db_engine(db_type, site_name)
    # 导出表--基准字段
    export_base_cols = [
        "search_term_id",
        "date_info",
        "search_term",
        "bsr_orders",
        "orders",
        "top100_asin",
        "top100_orders",
        "top100_market_share",
        "top100_is_new",
        "aadd_bsr_orders",
        "aadd_video_num",
        "aadd_no_video_num",
        "no_aadd_no_video_num",
        "no_aadd_video_num",
        "ao_range_val1",
        "ao_range_val2",
        "ao_range_val3",
        "ao_range_val4",
        "ao_range_val5",
        "ao_range_val6",
        "ao_range_val7",
        "ao_range_val8",
        "ao_range_val9",
        "ao_range_val10",
        "ao_range_val11",
        "ao_range_val12",
        "ao_range_market_share1",
        "ao_range_market_share2",
        "ao_range_market_share3",
        "ao_range_market_share4",
        "ao_range_market_share5",
        "ao_range_market_share6",
        "ao_range_market_share7",
        "ao_range_market_share8",
        "ao_range_market_share9",
        "ao_range_market_share10",
        "ao_range_market_share11",
        "ao_range_market_share12",
        "launch_time_num1",
        "launch_time_num2",
        "launch_time_num3",
        "launch_time_num4",
        "launch_time_num5",
        "launch_time_num6",
        "launch_time_num7",
        "launch_time_num8",
        "launch_time_market_share1",
        "launch_time_market_share2",
        "launch_time_market_share3",
        "launch_time_market_share4",
        "launch_time_market_share5",
        "launch_time_market_share6",
        "launch_time_market_share7",
        "launch_time_market_share8",
        "top20_asin",
        "top20_orders",
        "top20_brand",
        "top20_brand_new_num_proportion",
        "top20_brand_bsr_oders",
        "top20_brand_market_share",
        "comments_num1",
        "comments_num2",
        "comments_num3",
        "comments_num4",
        "comments_num5",
        "comments_num6",
        "comments_num7",
        "comments_num8",
        "comments_num9",
        "comments_num10",
        "comments_num11",
        "comments_num12",
        "comments_num13",
        "comments_num_market_share1",
        "comments_num_market_share2",
        "comments_num_market_share3",
        "comments_num_market_share4",
        "comments_num_market_share5",
        "comments_num_market_share6",
        "comments_num_market_share7",
        "comments_num_market_share8",
        "comments_num_market_share9",
        "comments_num_market_share10",
        "comments_num_market_share11",
        "comments_num_market_share12",
        "comments_num_market_share13",
        "buy_box_name",
        "buy_box_num",
        "seller_name",
        "seller_num",
        "seller_bsr_orders",
        "color_name",
        "color_num",
        "total_asin_num",
        "new_asin_num"
    ]
    export_table = "us_aba_last_month_report_2023_12_copy"
    export_cols = export_base_cols + [
    "new_asin_bsr_orders",
    "rating_section",
    "rating_market_share_section",
    "size_name",
    "size_num",
    "package_num_trend",
    "package_num_trend_market_share",
    "package_num_corresponding_asin",
    "price_interval",
    "price_interval_asin_count",
    "price_interval_asin_market_share",
    "color_bsr_orders_percent",
    "size_bsr_orders_percent"
    ]

    partition_dict = {
        "site_name": site_name,
        "date_type": date_type,
        "date_info": date_info
    }
    sh = CommonUtil.build_export_sh(
        site_name=site_name,
        db_type=db_type,
        hive_tb="dwt_aba_st_analytics_report",
        export_tb=export_table,
        col=export_cols,
        partition_dict=partition_dict
    )

    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh, ignore_err=False)
    client.close()
