import os
import sys
from datetime import datetime

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil, DateTypes
from utils.db_util import DBUtil

if __name__ == '__main__':
    # 获取入参
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None)
    date_info = CommonUtil.get_sys_arg(3, None)


    #  获取最后一个参数
    test_flag = CommonUtil.get_sys_arg(len(sys.argv) - 1, None)

    print(f"执行参数为{sys.argv}")

    print(test_flag)

    if test_flag == 'test':
        db_type = 'postgresql_test'
        print("导出到测试库中")
    else:
        CommonUtil.judge_is_work_hours(site_name=site_name, date_type=date_type, date_info=date_info,
                                       principal='chenyuanjie',
                                       priority=1, export_tools_type=1, belonging_to_process=f'新ABA流程_{date_type}')
        if date_type in (DateTypes.month.name, DateTypes.week.name,DateTypes.month_week.name):
            db_type = 'postgresql_cluster'
            print("导出到PG-Cluster库中")
        else:
            db_type = "postgresql"
            print("导出到PG库中")

    # 获取数据库连接
    engine = DBUtil.get_db_engine(db_type, site_name)
    # 导出表--基准字段
    export_base_cols = [
        "search_term_id",
        "date_info",
        "search_term",
        "bsr_orders",
        "orders",
        "top100_asin",
        "top100_orders",
        "top100_market_share",
        "top100_is_new",
        "aadd_bsr_orders",
        "aadd_video_num",
        "aadd_no_video_num",
        "no_aadd_no_video_num",
        "no_aadd_video_num",
        "ao_range_val1",
        "ao_range_val2",
        "ao_range_val3",
        "ao_range_val4",
        "ao_range_val5",
        "ao_range_val6",
        "ao_range_val7",
        "ao_range_val8",
        "ao_range_val9",
        "ao_range_val10",
        "ao_range_val11",
        "ao_range_val12",
        "ao_range_market_share1",
        "ao_range_market_share2",
        "ao_range_market_share3",
        "ao_range_market_share4",
        "ao_range_market_share5",
        "ao_range_market_share6",
        "ao_range_market_share7",
        "ao_range_market_share8",
        "ao_range_market_share9",
        "ao_range_market_share10",
        "ao_range_market_share11",
        "ao_range_market_share12",
        "launch_time_num1",
        "launch_time_num2",
        "launch_time_num3",
        "launch_time_num4",
        "launch_time_num5",
        "launch_time_num6",
        "launch_time_num7",
        "launch_time_num8",
        "launch_time_market_share1",
        "launch_time_market_share2",
        "launch_time_market_share3",
        "launch_time_market_share4",
        "launch_time_market_share5",
        "launch_time_market_share6",
        "launch_time_market_share7",
        "launch_time_market_share8",
        "top20_asin",
        "top20_orders",
        "top20_brand",
        "top20_brand_new_num_proportion",
        "top20_brand_bsr_oders",
        "top20_brand_market_share",
        "comments_num1",
        "comments_num2",
        "comments_num3",
        "comments_num4",
        "comments_num5",
        "comments_num6",
        "comments_num7",
        "comments_num8",
        "comments_num9",
        "comments_num10",
        "comments_num11",
        "comments_num12",
        "comments_num13",
        "comments_num_market_share1",
        "comments_num_market_share2",
        "comments_num_market_share3",
        "comments_num_market_share4",
        "comments_num_market_share5",
        "comments_num_market_share6",
        "comments_num_market_share7",
        "comments_num_market_share8",
        "comments_num_market_share9",
        "comments_num_market_share10",
        "comments_num_market_share11",
        "comments_num_market_share12",
        "comments_num_market_share13",
        "buy_box_name",
        "buy_box_num",
        "seller_name",
        "seller_num",
        "seller_bsr_orders",
        "color_name",
        "color_num",
        "total_asin_num",
        "new_asin_num"
    ]

    if date_type in (DateTypes.day.name,DateTypes.week.name,DateTypes.month.name):
        # 导出表--基准表名
        export_base_tb = f"{site_name}_aba_last_{date_type}_report"
        # 导出表--表名后缀
        suffix = str(date_info).replace("-", "_")
        # 导出表表名
        export_table = f"{export_base_tb}_{suffix}"
        # 根据date_type获取date_info的下一个值
        next_val = CommonUtil.get_next_val(date_type, date_info)

        if date_type == DateTypes.day.name:
            year_month = CommonUtil.reformat_date(date_info, "%Y-%m-%d", "%Y-%m")
            year_month_before = CommonUtil.get_month_offset(year_month, -1).replace("-", "_")
            year_month = year_month.replace("-", "_")
            export_master_tb = f"{export_base_tb}_{year_month}"
            export_tb_before = f"{export_base_tb}_{year_month_before}"
            export_cols = [
            "search_term_id",
            "date_info",
            "search_term",
            "total_asin_num",
            "new_asin_num",
            "orders",
            "bsr_orders",
            "top100_asin",
            "top100_orders",
            "top100_market_share",
            "top100_is_new",
            "ao_range_val1",
            "ao_range_val2",
            "ao_range_val3",
            "ao_range_val4",
            "ao_range_val5",
            "ao_range_val6",
            "ao_range_val7",
            "ao_range_val8",
            "ao_range_val9",
            "ao_range_val10",
            "ao_range_val11",
            "ao_range_val12",
            "ao_range_market_share1",
            "ao_range_market_share2",
            "ao_range_market_share3",
            "ao_range_market_share4",
            "ao_range_market_share5",
            "ao_range_market_share6",
            "ao_range_market_share7",
            "ao_range_market_share8",
            "ao_range_market_share9",
            "ao_range_market_share10",
            "ao_range_market_share11",
            "ao_range_market_share12",
            "aadd_bsr_orders"
            ]

        elif date_type == DateTypes.week.name:
            year = CommonUtil.safeIndex(date_info.split("-"), 0, None)
            year_before = str(int(year) - 1)
            export_master_tb = f"{export_base_tb}_{year}"
            export_tb_before = f"{export_base_tb}_{year_before}"
            export_cols = export_base_cols + [
            "rating_section",
            "rating_market_share_section",
            "size_name",
            "size_num",
            "package_num_trend",
            "package_num_trend_market_share",
            "package_num_corresponding_asin",
            "price_interval",
            "price_interval_asin_count",
            "price_interval_asin_market_share"
            ]

        elif date_type == DateTypes.month.name:
            year = CommonUtil.safeIndex(date_info.split("-"), 0, None)
            year_before = str(int(year) - 1)
            export_master_tb = f"{export_base_tb}_{year}"
            export_tb_before = f"{export_base_tb}_{year_before}"
            export_cols = export_base_cols + [
            "new_asin_bsr_orders",
            "rating_section",
            "rating_market_share_section",
            "size_name",
            "size_num",
            "package_num_trend",
            "package_num_trend_market_share",
            "package_num_corresponding_asin",
            "price_interval",
            "price_interval_asin_count",
            "price_interval_asin_market_share",
            "color_bsr_orders_percent",
            "size_bsr_orders_percent"
            ]

    elif date_type in (DateTypes.month_week.name ,DateTypes.last30day.name):
        export_tb_target = f"{site_name}_aba_last_30_day_report"
        export_tb_copy = f"{export_tb_target}_copy"
        export_table = export_tb_copy
        export_cols = export_base_cols + [
            "new_asin_bsr_orders",
            "rating_section",
            "rating_market_share_section",
            "size_name",
            "size_num",
            "package_num_trend",
            "package_num_trend_market_share",
            "package_num_corresponding_asin",
            "price_interval",
            "price_interval_asin_count",
            "price_interval_asin_market_share",
            "color_bsr_orders_percent",
            "size_bsr_orders_percent"
        ]

    else:
        assert date_type, "输入的date_type有误，请检查！"
        quit()

    # sql建表和创建分区
    if date_type in (DateTypes.day.name,DateTypes.week.name,DateTypes.month.name):
        sql = f"""
            create table if not exists {export_master_tb}
                (
                    like {export_tb_before} including indexes including comments
                )
            partition by range (date_info);
    
            create table if not exists {export_table} partition of {export_master_tb} for values from ('{date_info}') to ('{next_val}');
            truncate table {export_table};
            """
    elif date_type in (DateTypes.month_week.name, DateTypes.last30day.name):
        sql = f"""
             create table if not exists {export_tb_copy} 
            (
                like {export_tb_target} including indexes including comments
            );
            truncate table {export_tb_copy};
                                      """
    DBUtil.engine_exec_sql(engine, sql)

    if test_flag == "month_append":
        partition_dict = {
            "site_name": site_name,
            "date_type": "month",
            "date_info": date_info
        }
    else:
        partition_dict = {
            "site_name": site_name,
            "date_type": date_type,
            "date_info": date_info
        }

    # 导出执行sqoop的sh编写
    sh = CommonUtil.build_export_sh(
        site_name=site_name,
        db_type=db_type,
        hive_tb="dwt_aba_st_analytics_report",
        export_tb=export_table,
        col=export_cols,
        partition_dict=partition_dict
    )

    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh, ignore_err=False)
    client.close()
    if date_type in (DateTypes.month_week.name, DateTypes.last30day.name):
        DBUtil.exchange_tb(engine,
                           source_tb_name=export_tb_copy,
                           target_tb_name=export_tb_target,
                           cp_index_flag=False)
        update_workflow_sql = f"""
            replace INTO selection.workflow_everyday
            (site_name, report_date, status, status_val, table_name, date_type, page, is_end, remark,export_db_type)
            VALUES('{site_name}', '{datetime.now().date()}', '导出PG数据库完成', 14, 'us_aba_last_30_day', '30_day', 'ABA搜索词', '是', 'ABA搜索词最近30天表','{db_type}');
        """
    else:
        update_workflow_sql = f"""
                UPDATE selection.workflow_everyday SET status='导出PG数据库完成', status_val=14,is_end ='是',export_db_type = '{db_type}'  
                WHERE site_name= '{site_name}' and date_type='{date_type}' and report_date= '{date_info}'  and page ='ABA搜索词'
            """
    # 往导出流程表插入导出完成数据，方便监听导出脚本是否全部完成
    CommonUtil.modify_export_workflow_status(update_workflow_sql, site_name, date_type, date_info)

