import os
from dotenv import load_dotenv

basedir = os.path.abspath(os.path.dirname(__file__))

dotenv_path = os.path.join(basedir, '.env')
load_dotenv(dotenv_path)

db_conn_conf = {
    "host": "192.168.10.224",
    "port": "5433",
    "username": "postgres",
    "pwd": "fazAqRRVV9vDmwDNRNb593ht5TxYVrfTyHJSJ3BS",
}


class Config:
    # falsk的内置config key: https://flask.palletsprojects.com/en/2.0.x/config/
    SECRET_KEY = os.environ.get('SECRET_KEY') or os.urandom(16)
    SQLALCHEMY_COMMIT_ON_TEARDOWN = True
    SQLALCHEMY_TRACK_MODIFICATIONS = True

    PRODUCTION_CONFIG = False

    # init_app是为了在初始化app时附加一些额外配置用的
    @classmethod
    def init_app(cls, app):
        pass


class DevelopmentConfig(Config):
    # 设置了FLASK_ENV环境变量自动是DEBUG模式
    # DEBUG = True
    # 没有指定DEV_DATABASE_URL则使用sqlite

    SQLALCHEMY_BINDS = {
        'us': f'postgresql://{db_conn_conf.get("username")}:{db_conn_conf.get("pwd")}@{db_conn_conf.get("host")}:{db_conn_conf.get("port")}/selection',
        'uk': f'postgresql://{db_conn_conf.get("username")}:{db_conn_conf.get("pwd")}@{db_conn_conf.get("host")}:{db_conn_conf.get("port")}/selection_uk',
        'de': f'postgresql://{db_conn_conf.get("username")}:{db_conn_conf.get("pwd")}@{db_conn_conf.get("host")}:{db_conn_conf.get("port")}/selection_de',
        'fr': f'postgresql://{db_conn_conf.get("username")}:{db_conn_conf.get("pwd")}@{db_conn_conf.get("host")}:{db_conn_conf.get("port")}/selection_fr',
        'it': f'postgresql://{db_conn_conf.get("username")}:{db_conn_conf.get("pwd")}@{db_conn_conf.get("host")}:{db_conn_conf.get("port")}/selection_it',
        'es': f'postgresql://{db_conn_conf.get("username")}:{db_conn_conf.get("pwd")}@{db_conn_conf.get("host")}:{db_conn_conf.get("port")}/selection_es'
    }
    SQLALCHEMY_DATABASE_URI = SQLALCHEMY_BINDS['us']

    # 查询时会显示原始SQL语句
    SQLALCHEMY_ECHO = True
    PRODUCTION_CONFIG = False


class ProductionConfig(Config):
    """
    生产环境
    """
    SQLALCHEMY_BINDS = {
        'us': f'postgresql://{db_conn_conf.get("username")}:{db_conn_conf.get("pwd")}@{db_conn_conf.get("host")}:{db_conn_conf.get("port")}/selection',
        'uk': f'postgresql://{db_conn_conf.get("username")}:{db_conn_conf.get("pwd")}@{db_conn_conf.get("host")}:{db_conn_conf.get("port")}/selection_uk',
        'de': f'postgresql://{db_conn_conf.get("username")}:{db_conn_conf.get("pwd")}@{db_conn_conf.get("host")}:{db_conn_conf.get("port")}/selection_de',
        'fr': f'postgresql://{db_conn_conf.get("username")}:{db_conn_conf.get("pwd")}@{db_conn_conf.get("host")}:{db_conn_conf.get("port")}/selection_fr',
        'it': f'postgresql://{db_conn_conf.get("username")}:{db_conn_conf.get("pwd")}@{db_conn_conf.get("host")}:{db_conn_conf.get("port")}/selection_it',
        'es': f'postgresql://{db_conn_conf.get("username")}:{db_conn_conf.get("pwd")}@{db_conn_conf.get("host")}:{db_conn_conf.get("port")}/selection_es'
    }
    SQLALCHEMY_DATABASE_URI = SQLALCHEMY_BINDS['us']

    # 查询时会显示原始SQL语句
    SQLALCHEMY_ECHO = False
    PRODUCTION_CONFIG = True


config = {
    'development': DevelopmentConfig,
    'production': ProductionConfig,
    'default': DevelopmentConfig
}
