/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.cli;

import com.cloudera.sqoop.cli.RelatedOptions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ToolOptions
implements Iterable<RelatedOptions> {
    private List<RelatedOptions> optGroups = new ArrayList<RelatedOptions>();

    public void addOptions(RelatedOptions opts) {
        this.optGroups.add(opts);
    }

    public void addUniqueOptions(RelatedOptions opts) {
        if (!this.containsGroup(opts.getTitle())) {
            this.optGroups.add(opts);
        }
    }

    public boolean containsGroup(String title) {
        for (RelatedOptions related : this) {
            if (!related.getTitle().equals(title)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<RelatedOptions> iterator() {
        return this.optGroups.iterator();
    }

    public Options merge() {
        Options mergedOpts = new Options();
        int totalOpts = 0;
        for (RelatedOptions relatedOpts : this) {
            for (Object optObj : relatedOpts.getOptions()) {
                Option opt = (Option)optObj;
                mergedOpts.addOption(opt);
                ++totalOpts;
            }
        }
        return mergedOpts;
    }

    public void printHelp() {
        this.printHelp(new HelpFormatter());
    }

    public void printHelp(HelpFormatter formatter) {
        this.printHelp(formatter, new PrintWriter(System.out, true));
    }

    public void printHelp(HelpFormatter formatter, PrintWriter pw) {
        boolean first = true;
        for (RelatedOptions optGroup : this.optGroups) {
            if (!first) {
                pw.println("");
            }
            pw.println(optGroup.getTitle() + ":");
            formatter.printOptions(pw, formatter.getWidth(), (Options)optGroup, 0, 4);
            first = false;
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.printHelp(new HelpFormatter(), new PrintWriter(sw));
        sw.flush();
        return sw.getBuffer().toString();
    }
}

