/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.SQLServerResilientExportOutputFormat;
import org.apache.sqoop.mapreduce.SQLServerUpdateDBExecThread;
import org.apache.sqoop.mapreduce.db.DBConfiguration;

public class SQLServerResilientUpdateOutputFormat<K extends SqoopRecord, V>
extends SQLServerResilientExportOutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(SQLServerResilientUpdateOutputFormat.class);

    @Override
    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        DBConfiguration dbConf = new DBConfiguration(conf);
        if (null == conf.get("mapreduce.jdbc.url")) {
            throw new IOException("Database connection URL is not set.");
        }
        if (null == dbConf.getOutputTableName()) {
            throw new IOException("Table name is not set for export.");
        }
        if (null == dbConf.getOutputFieldNames()) {
            throw new IOException("Output field names are null.");
        }
        if (null == conf.get("sqoop.mapreduce.export.update.col")) {
            throw new IOException("Update key column is not set for export.");
        }
    }

    @Override
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new SQLServerUpdateRecordWriter(context);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public class SQLServerUpdateRecordWriter<K extends SqoopRecord, V>
    extends SQLServerResilientExportOutputFormat.SQLServerExportRecordWriter<K, V> {
        private final Log LOG;

        public SQLServerUpdateRecordWriter(TaskAttemptContext context) throws IOException {
            super(context);
            this.LOG = LogFactory.getLog(SQLServerUpdateRecordWriter.class);
        }

        @Override
        protected void initializeExecThread() throws IOException {
            this.execThread = new SQLServerUpdateDBExecThread();
            this.execThread.initialize(this.conf);
        }
    }
}

