import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.common_util import CommonUtil
from utils.secure_db_client import get_remote_engine

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None)
    date_info = CommonUtil.get_sys_arg(3, None)
    assert site_name is not None, "site_name 不能为空！"
    assert date_type is not None, "date_type 不能为空！"
    assert date_info is not None, "date_info 不能为空！"

    d1, d2 = CommonUtil.split_month_week_date(date_type, date_info)
    d2 = f'0{d2}' if int(d2) < 10 else f'{d2}'
    db_type = 'postgresql_14'
    import_tb = f"{site_name}_bs_category_asin_detail_month_{d1}_{d2}"
    if date_type == 'day':
        import_tb = f"{site_name}_bs_category_asin_detail_day_{date_info.replace('-', '_')}"

    query = f"""
        select 
            id, asin, null as week, best_sellers_rank, created_time as created_at, updated_time as updated_at, last_herf, all_best_sellers_href
        from {import_tb}
        where 1=1
        and \$CONDITIONS
    """

    hive_tb = "ods_bs_category_asin_detail"
    partition_dict = {
        "site_name": site_name,
        "date_type": date_type,
        "date_info": date_info,
    }
    hdfs_path = CommonUtil.build_hdfs_path(hive_tb, partition_dict=partition_dict)

    engine = get_remote_engine(
        site_name=site_name,
        db_type=db_type
    )

    engine.sqoop_raw_import(
        query=query,
        hive_table=hive_tb,
        hdfs_path=hdfs_path,
        partitions=partition_dict,
        m=50,
        split_by='id'
    )

    pass
