import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.secure_db_client import get_remote_engine
from datetime import datetime, timedelta


def is_saturday(date_str: str, fmt: str = "%Y-%m-%d") -> bool:
    dt = datetime.strptime(date_str, fmt)
    # weekday(): 周一=0 ... 周六=5 周日=6
    return dt.weekday() == 5

site_name = sys.argv[1]  # 参数1：站点
date_type = sys.argv[2]  # 参数2：类型：day/week/4_week/month/quarter
date_info = sys.argv[3]  # 参数3：年-月-日/年-周/年-月/年-季, 比如: 2022-1

db_type = "mysql"

engine = get_remote_engine(
        site_name=site_name,
        db_type=db_type
    )

hive_table = "ods_keepa_finder_asin"
partition_dict = {
    "site_name": site_name,
    "date_type": date_type,
    "date_info": date_info,
}
sql_query = f"select id, request_id, asin, tracking_since from keepa_finder_asin where 1=1 " \
            f"and \$CONDITIONS"

is_saturday_flag = is_saturday(date_info)

if is_saturday_flag:
    print(f"{date_info}是周六, 因此需要进行导入")
    engine.sqoop_raw_import(
            query=sql_query,
            hive_table=hive_table,
            partitions=partition_dict,
            m=1,
        )
else:
    print(f"{date_info}不是周六, 因此不需要进行导入")


