#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh

# 根据site_name来判断数据库名称
if [ $1 == all ];
then
    site_name_array=(uk de es fr it us)
else
    site_name_array=($1)
fi
echo "site_name_array: ${site_name_array}"

date_type=$2
date_info=$3
export_env=$4
year=`echo $date_info | cut -d \- -f 1`

# 根据export_env判断是否导出到PG测试环境
if [ $export_env == test ]
then
    db_type=pgsqltest
    echo "同步到测试库中"
else
    db_type=postgresql
    echo "同步到正式库中"
fi



for site_name in ${site_name_array[*]}
    do
		echo 1. 当前连接的数据库站点: ${site_name}
		if [ ${site_name} == us ];
		then
			db=selection
		else
			db=selection_${site_name}
		fi
		echo "db: ${db}"

		# 导出数据
		if [ $date_type == day ]
		then
			month=`echo $date_info | cut -d \- -f 2`
            day=`echo $date_info | cut -d \- -f 3`
            import_table=${site_name}_aba_last_day_report_${year}_${month}_${day}
            truncate_table=${site_name}_aba_last_day_report_${year}_${month}_${day}
			cols="search_term_id,date_info,search_term,total_asin_num,new_asin_num,orders,bsr_orders,price_range_num1,price_range_market_share1,price_range_num2,price_range_market_share2,price_range_num3,price_range_market_share3,price_range_num4,price_range_market_share4,price_range_num5,price_range_market_share5,price_range_num6,price_range_market_share6,price_range_num7,price_range_market_share7,price_range_num8,price_range_market_share8,price_range_num9,price_range_market_share9,price_range_num10,price_range_market_share10,price_range_num11,price_range_market_share11,price_range_num12,price_range_market_share12,price_range_num13,price_range_market_share13,price_range_num14,price_range_market_share14,price_range_num15,price_range_market_share15,price_range_num16,price_range_market_share16,price_range_num17,price_range_market_share17,price_range_num18,price_range_market_share18,ao_range_val1,ao_range_val2,ao_range_val3,ao_range_val4,ao_range_val5,ao_range_val6,ao_range_val7,ao_range_val8,ao_range_val9,ao_range_val10,ao_range_val11,ao_range_val12,top100_asin,top100_orders,top100_market_share,top100_is_new,ao_range_market_share1,ao_range_market_share2,ao_range_market_share3,ao_range_market_share4,ao_range_market_share5,ao_range_market_share6,ao_range_market_share7,ao_range_market_share8,ao_range_market_share9,ao_range_market_share10,ao_range_market_share11,ao_range_market_share12,aadd_bsr_orders"
		elif [ $date_type == week ]
		then
			week=`echo $date_info | cut -d \- -f 2`
			import_table=${site_name}_aba_last_week_report_${year}_${week}
            truncate_table=${site_name}_aba_last_week_report_${year}_${week}
			cols="search_term_id,date_info,search_term,bsr_orders,orders,top100_asin,top100_orders,top100_market_share,top100_is_new,aadd_bsr_orders,aadd_video_num,aadd_no_video_num,no_aadd_no_video_num,no_aadd_video_num,price_range_num1,price_range_market_share1,price_range_num2,price_range_market_share2,price_range_num3,price_range_market_share3,price_range_num4,price_range_market_share4,price_range_num5,price_range_market_share5,price_range_num6,price_range_market_share6,price_range_num7,price_range_market_share7,price_range_num8,price_range_market_share8,price_range_num9,price_range_market_share9,price_range_num10,price_range_market_share10,price_range_num11,price_range_market_share11,price_range_num12,price_range_market_share12,price_range_num13,price_range_market_share13,price_range_num14,price_range_market_share14,price_range_num15,price_range_market_share15,price_range_num16,price_range_market_share16,price_range_num17,price_range_market_share17,price_range_num18,price_range_market_share18,ao_range_val1,ao_range_val2,ao_range_val3,ao_range_val4,ao_range_val5,ao_range_val6,ao_range_val7,ao_range_val8,ao_range_val9,ao_range_val10,ao_range_val11,ao_range_val12,ao_range_market_share1,ao_range_market_share2,ao_range_market_share3,ao_range_market_share4,ao_range_market_share5,ao_range_market_share6,ao_range_market_share7,ao_range_market_share8,ao_range_market_share9,ao_range_market_share10,ao_range_market_share11,ao_range_market_share12,launch_time_num1,launch_time_num2,launch_time_num3,launch_time_num4,launch_time_num5,launch_time_num6,launch_time_num7,launch_time_num8,launch_time_market_share1,launch_time_market_share2,launch_time_market_share3,launch_time_market_share4,launch_time_market_share5,launch_time_market_share6,launch_time_market_share7,launch_time_market_share8,top20_asin,top20_orders,top20_brand,top20_brand_new_num_proportion,top20_brand_bsr_oders,top20_brand_market_share,comments_num1,comments_num2,comments_num3,comments_num4,comments_num5,comments_num6,comments_num7,comments_num8,comments_num9,comments_num10,comments_num11,comments_num12,comments_num13,comments_num_market_share1,comments_num_market_share2,comments_num_market_share3,comments_num_market_share4,comments_num_market_share5,comments_num_market_share6,comments_num_market_share7,comments_num_market_share8,comments_num_market_share9,comments_num_market_share10,comments_num_market_share11,comments_num_market_share12,comments_num_market_share13,buy_box_name,buy_box_num,seller_name,seller_num,seller_bsr_orders,total_asin_num,new_asin_num,color_name,color_num,rating_section,rating_market_share_section,size_name,size_num"
		elif [ $date_type == month ]
		then
			month=`echo $date_info | cut -d \- -f 2`
            import_table=${site_name}_aba_last_month_report_${year}_${month}
            truncate_table=${site_name}_aba_last_month_report_${year}_${month}
			cols="search_term_id,date_info,search_term,bsr_orders,orders,top100_asin,top100_orders,top100_market_share,top100_is_new,aadd_bsr_orders,aadd_video_num,aadd_no_video_num,no_aadd_no_video_num,no_aadd_video_num,price_range_num1,price_range_market_share1,price_range_num2,price_range_market_share2,price_range_num3,price_range_market_share3,price_range_num4,price_range_market_share4,price_range_num5,price_range_market_share5,price_range_num6,price_range_market_share6,price_range_num7,price_range_market_share7,price_range_num8,price_range_market_share8,price_range_num9,price_range_market_share9,price_range_num10,price_range_market_share10,price_range_num11,price_range_market_share11,price_range_num12,price_range_market_share12,price_range_num13,price_range_market_share13,price_range_num14,price_range_market_share14,price_range_num15,price_range_market_share15,price_range_num16,price_range_market_share16,price_range_num17,price_range_market_share17,price_range_num18,price_range_market_share18,ao_range_val1,ao_range_val2,ao_range_val3,ao_range_val4,ao_range_val5,ao_range_val6,ao_range_val7,ao_range_val8,ao_range_val9,ao_range_val10,ao_range_val11,ao_range_val12,ao_range_market_share1,ao_range_market_share2,ao_range_market_share3,ao_range_market_share4,ao_range_market_share5,ao_range_market_share6,ao_range_market_share7,ao_range_market_share8,ao_range_market_share9,ao_range_market_share10,ao_range_market_share11,ao_range_market_share12,launch_time_num1,launch_time_num2,launch_time_num3,launch_time_num4,launch_time_num5,launch_time_num6,launch_time_num7,launch_time_num8,launch_time_market_share1,launch_time_market_share2,launch_time_market_share3,launch_time_market_share4,launch_time_market_share5,launch_time_market_share6,launch_time_market_share7,launch_time_market_share8,top20_asin,top20_orders,top20_brand,top20_brand_new_num_proportion,top20_brand_bsr_oders,top20_brand_market_share,comments_num1,comments_num2,comments_num3,comments_num4,comments_num5,comments_num6,comments_num7,comments_num8,comments_num9,comments_num10,comments_num11,comments_num12,comments_num13,comments_num_market_share1,comments_num_market_share2,comments_num_market_share3,comments_num_market_share4,comments_num_market_share5,comments_num_market_share6,comments_num_market_share7,comments_num_market_share8,comments_num_market_share9,comments_num_market_share10,comments_num_market_share11,comments_num_market_share12,comments_num_market_share13,buy_box_name,buy_box_num,seller_name,seller_num,seller_bsr_orders,total_asin_num,new_asin_num,color_name,color_num,new_asin_bsr_orders,rating_section,rating_market_share_section,size_name,size_num"
		else
			echo "输入错误"
		fi
		
		hive_table=dwt_aba_st_analytics_report
		echo import_table:$import_table, hive_table:$hive_table
		#db_type=postgresql
		#db_type=mysql
		maps=20
		p_keys="site_name,date_type,date_info"
		p_values="$site_name,$date_type,$date_info"
		truncate_data
		export_data
	done
