#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh


# author: huangjian
# usage: 同步us站点的日asin详情表
# params: $1-->site_name; $2-->date_type; $3-->day
# version: 2.0
# create_date:2022-11-28
# update_date:2022-11-28

# 根据site_name来判断数据库名称
if [ $1 == all ];
then
    # site_name_array=(us uk de es fr it)
    site_name_array=(us)
else
    site_name_array=($1)
fi
echo "site_name_array: ${site_name_array}"

date_type=$2
date_info=$3
year=`echo $date_info | cut -d \- -f 1`
if [ $date_type == 'week' ]
then 
	week=`echo $date_info | cut -d \- -f 2`
elif [ $date_type == 'day' ]
then
	month=`echo $date_info | cut -d \- -f 2`
	day=`echo $date_info | cut -d \- -f 3`
fi




for site_name in ${site_name_array[*]}
	do
		echo 1.site_name:${site_name}, year:${year}, month:${month}, day:${day}
                if [ ${site_name} == us ];
                then
                        db=selection
                else
                        db=selection_${site_name}
                fi
                echo "db: ${db}"		

		echo 2. 先删除已经存在的分区
		hive_table=ods_asin_detail
		hdfs_path="/home/big_data_selection/ods/ods_asin_detail/site_name=${site_name}/date_type=${date_type}/date_info=${date_info}"
		hdfs dfs -rm -r ${hdfs_path}/*
		echo 3. 导入数据
		db_type=postgresql
		queue=default
		import_table=${site_name}_asin_detail_${year}_${month}_${day}
		query="select id,asin,img_url,title,title_len,price,rating,total_comments,buy_box_seller_type,page_inventory,category,volume,weight,rank,launch_time,created_time as created_at,updated_time as updated_at,category_state,img_num,img_type,activity_type,one_two_val,three_four_val,five_six_val,eight_val,qa_num,one_star,two_star,three_star,four_star,five_star,low_star,together_asin,brand,ac_name,material,node_id,data_type,sp_num,describe from ${import_table} where 1=1 and \$CONDITIONS"
		import_data
	done

