/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.GenericJdbcManager;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.ExportBatchOutputFormat;
import com.cloudera.sqoop.mapreduce.JdbcExportJob;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.mapreduce.db.Db2DataDrivenDBInputFormat;
import org.apache.sqoop.util.LoggingUtils;

public class Db2Manager
extends GenericJdbcManager {
    public static final Log LOG = LogFactory.getLog((String)Db2Manager.class.getName());
    private static final String DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";

    public Db2Manager(SqoopOptions opts) {
        super(DRIVER_CLASS, opts);
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        context.setConnManager(this);
        context.setInputFormat(Db2DataDrivenDBInputFormat.class);
        super.importTable(context);
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        JdbcExportJob exportJob = new JdbcExportJob(context, null, null, ExportBatchOutputFormat.class);
        exportJob.runExport();
    }

    @Override
    public String getCurTimestampQuery() {
        return "SELECT CURRENT TIMESTAMP FROM SYSIBM.SYSDUMMY1 WITH UR";
    }

    @Override
    public String[] listDatabases() {
        Connection conn = null;
        ResultSet rset = null;
        ArrayList<String> databases = new ArrayList<String>();
        try {
            conn = this.getConnection();
            rset = conn.getMetaData().getSchemas();
            while (rset.next()) {
                databases.add(rset.getString(1));
            }
            conn.commit();
        }
        catch (SQLException sqle) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ce) {
                LoggingUtils.logAll(LOG, "Failed to rollback transaction", ce);
            }
            LoggingUtils.logAll(LOG, "Failed to list databases", sqle);
            throw new RuntimeException(sqle);
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException re) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", re);
                }
            }
        }
        return databases.toArray(new String[databases.size()]);
    }
}

