/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.mapreduce.db.DBInputFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.sqoop.manager.oracle.OraOopOracleDataChunk;

class OraOopDBInputSplit
extends DBInputFormat.DBInputSplit {
    private int splitId;
    private double totalNumberOfBlocksInAllSplits;
    private String splitLocation;
    private List<OraOopOracleDataChunk> oracleDataChunks;

    public OraOopDBInputSplit() {
        this.splitId = -1;
        this.splitLocation = "";
        this.oracleDataChunks = new ArrayList<OraOopOracleDataChunk>();
    }

    public OraOopDBInputSplit(List<OraOopOracleDataChunk> dataChunks) {
        this.setOracleDataChunks(dataChunks);
    }

    public void setOracleDataChunks(List<OraOopOracleDataChunk> dataChunks) {
        this.oracleDataChunks = dataChunks;
    }

    public List<OraOopOracleDataChunk> getDataChunks() {
        return this.oracleDataChunks;
    }

    public int getNumberOfDataChunks() {
        if (this.getDataChunks() == null) {
            return 0;
        }
        return this.getDataChunks().size();
    }

    @Override
    public String[] getLocations() throws IOException {
        if (this.splitLocation.isEmpty()) {
            return new String[0];
        }
        return new String[]{this.splitLocation};
    }

    @Override
    public long getLength() {
        return this.getTotalNumberOfBlocksInThisSplit();
    }

    public int getTotalNumberOfBlocksInThisSplit() {
        if (this.getNumberOfDataChunks() == 0) {
            return 0;
        }
        int result = 0;
        for (OraOopOracleDataChunk dataChunk : this.getDataChunks()) {
            result = (int)((long)result + dataChunk.getNumberOfBlocks());
        }
        return result;
    }

    public OraOopOracleDataChunk findDataChunkById(String id) {
        for (OraOopOracleDataChunk dataChunk : this.getDataChunks()) {
            if (!dataChunk.getId().equals(id)) continue;
            return dataChunk;
        }
        return null;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeInt(this.splitId);
        if (this.oracleDataChunks == null) {
            output.writeInt(0);
        } else {
            output.writeInt(this.oracleDataChunks.size());
            for (OraOopOracleDataChunk dataChunk : this.oracleDataChunks) {
                Text.writeString((DataOutput)output, (String)dataChunk.getClass().getName());
                dataChunk.write(output);
            }
        }
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.splitId = input.readInt();
        int dataChunkCount = input.readInt();
        if (dataChunkCount == 0) {
            this.oracleDataChunks = null;
        } else {
            this.oracleDataChunks = new ArrayList<OraOopOracleDataChunk>(dataChunkCount);
            for (int idx = 0; idx < dataChunkCount; ++idx) {
                OraOopOracleDataChunk dataChunk;
                try {
                    Class<?> dataChunkClass = Class.forName(Text.readString((DataInput)input));
                    dataChunk = (OraOopOracleDataChunk)dataChunkClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                dataChunk.readFields(input);
                this.oracleDataChunks.add(dataChunk);
            }
        }
    }

    public String getDebugDetails() {
        StringBuilder result = new StringBuilder();
        if (this.getNumberOfDataChunks() == 0) {
            result.append(String.format("Split[%s] does not contain any Oracle data-chunks.", this.splitId));
        } else {
            result.append(String.format("Split[%s] includes the Oracle data-chunks:\n", this.splitId));
            for (OraOopOracleDataChunk dataChunk : this.getDataChunks()) {
                result.append(dataChunk.toString());
            }
        }
        return result.toString();
    }

    protected int getSplitId() {
        return this.splitId;
    }

    protected void setSplitId(int newSplitId) {
        this.splitId = newSplitId;
    }

    protected void setSplitLocation(String newSplitLocation) {
        this.splitLocation = newSplitLocation;
    }

    protected void setTotalNumberOfBlocksInAllSplits(int newTotalNumberOfBlocksInAllSplits) {
        this.totalNumberOfBlocksInAllSplits = newTotalNumberOfBlocksInAllSplits;
    }
}

