/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.sqoop.mapreduce.ProgressThread;
import org.apache.sqoop.mapreduce.SqoopReducer;

public class AutoProgressReducer<KEYIN, VALIN, KEYOUT, VALOUT>
extends SqoopReducer<KEYIN, VALIN, KEYOUT, VALOUT> {
    public static final Log LOG = LogFactory.getLog((String)AutoProgressReducer.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Reducer.Context context) throws IOException, InterruptedException {
        ProgressThread thread = new ProgressThread((TaskInputOutputContext)context, LOG);
        try {
            thread.setDaemon(true);
            thread.start();
            super.run(context);
        }
        finally {
            LOG.debug((Object)"Instructing auto-progress thread to quit.");
            thread.signalShutdown();
            try {
                LOG.debug((Object)"Waiting for progress thread shutdown...");
                thread.join();
                LOG.debug((Object)"Progress thread shutdown detected.");
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)("Interrupted when waiting on auto-progress thread: " + ie.toString()), (Throwable)ie);
            }
        }
    }
}

