import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.secure_db_client import get_remote_engine

if __name__ == '__main__':
    site_name = sys.argv[1]
    date_info = sys.argv[2]

    db_type = "postgresql_cluster"
    export_tb = f"{site_name}_asin_profit_rate_calc"
    engine = get_remote_engine(
        site_name=site_name,
        db_type=db_type
    )

    engine.sqoop_raw_export(
        hive_table="dwt_flow_keepa_asin",
        import_table=export_tb,
        partitions={
            "site_name": site_name,
            "date_info": date_info
        },
        m=10,
        cols="asin,price,package_length,package_width,package_height,weight,category,part_key,source_month"
    )

    print("success")
