import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil
from utils.hdfs_utils import HdfsUtils


if __name__ == '__main__':
    hive_table = f"ods_merchantwords_other_search_term_data"
    partition_dict = {
        "site_name": 'us',
        "date_type": 'day',
        "date_info": '2024-05-06'
    }
    hdfs_path = CommonUtil.build_hdfs_path(hive_table, partition_dict=partition_dict)
    print(f"hdfs_path is {hdfs_path}")
    db_type = 'postgresql_16'
    import_table = "us_merchantwords_other_search_term"

    sql_query = f"""
        select 
         id,
         search_term,
         asin,
         page,
         buy_data,
         label,
         created_time,
         updated_time
        from {import_table} 
        where 1=1
        and \$CONDITIONS
    """
    # 进行schema和数据校验
    CommonUtil.check_schema_before_import(db_type=db_type,
                                          site_name='us',
                                          query=sql_query,
                                          hive_tb_name=hive_table,
                                          msg_usr=['chenyuanjie'],
                                          partition_dict=partition_dict)
    import_sh = CommonUtil.build_import_sh(site_name='us',
                                           db_type=db_type,
                                           query=sql_query,
                                           hdfs_path=hdfs_path,
                                           map_num=35,
                                           key='id'
                                           )
    HdfsUtils.delete_hdfs_file(hdfs_path)
    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, import_sh, ignore_err=False)
    CommonUtil.after_import(hdfs_path=hdfs_path, hive_tb=hive_table)
    client.close()