import requests

# 服务器地址
url = 'http://192.168.10.217:10001/img_search'

# 文件路径列表，上传多个文件
file_paths = [
    'D:\Amazon-Selection\pyspark_job\image_search\img/1.jpg',
    # 'D:\Amazon-Selection\pyspark_job\image_search\img/1.png',
    'D:\Amazon-Selection\pyspark_job\image_search\img/2.png',
]

# 将多个文件添加到请求中
files = [('file', (open(file_path, 'rb'))) for file_path in file_paths]

# 其他表单数据
data = {
    'site_name': 'us',
    'img_type': 'amazon_inv',
    'search_key': 'file',  # 使用文件方式进行查询
    'search_value': '',  # 在图片查询中可忽略
    'top_k': 5  # 设置查询结果的返回数量
}

# 发送请求
response = requests.post(url, files=files, data=data)

# 打印响应
if response.status_code == 200:
    print(response.json())
else:
    print(f"Error: {response.status_code}, {response.text}")
