import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil
from utils.db_util import DBUtil

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_info = CommonUtil.get_sys_arg(2, None)
    #  获取最后一个参数
    test_flag = CommonUtil.get_sys_arg(len(sys.argv) - 1, None)
    print(f"执行参数为{sys.argv}")

    if test_flag == 'test':
        db_type = 'postgresql_test'
        print("导出到测试库中")
    else:
        db_type = "postgresql"
        print("导出到PG库中")

    d_month_1 = CommonUtil.reformat_date(date_info, "%Y-%m-%d", "%Y_%m", )
    d_month_2 = CommonUtil.reformat_date(date_info, "%Y-%m-%d", "%Y-%m", )
    next_month = CommonUtil.get_month_offset(d_month_2, 1)

    suffix = CommonUtil.reformat_date(date_info, "%Y-%m-%d", "%Y_%m_%d", )
    export_master_tb = f"{site_name}_bsr_asin_detail_copy"
    export_tb = f"{export_master_tb}_{suffix}"

    engine = DBUtil.get_db_engine(db_type, site_name)
    with engine.connect() as connection:
        sql = f"""
                    xxxxxxxxxxxxxxxxxxxxxxxxxxxxx
                """
        print("================================执行sql================================")
        print(sql)
        connection.execute(sql)

    # 导出表名
    sh = CommonUtil.build_export_sh(
        site_name=site_name,
        db_type=db_type,
        hive_tb="xxxxxxxxxxxxxx",
        export_tb=export_tb,
        col=[],
        partition_dict={
            "site_name": site_name,
            "date_info": d_month_2
        }
    )

    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh, ignore_err=False)
    client.close()

    if test_flag != 'test':
        pass
        #  正式环境更新workflow_everyday
        # engine = DBUtil.get_db_engine("mysql", site_name)
        # with engine.connect() as connection:
        #     sql = f"""
        #       insert into workflow_everyday (site_name, report_date, status, status_val, table_name, date_type, page, is_end, remark)
        #         values ('{site_name}', '{date_info}', '导出PG数据库', 14, 'us_bsr_asin_rank', 'day', 'BSR榜单', '是', 'BS榜单对应的TOP100ASIN');
        #             """
        #     print("================================更新workflow_everyday================================")
        #     print(sql)
        #     connection.execute(sql)

    print("success")
