import os
import sys
from datetime import datetime

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil, DateTypes
from utils.db_util import DBUtil

if __name__ == '__main__':
    db_type = 'postgresql_cluster'
    print("导出到PG-Cluster库中")
    engine = DBUtil.get_db_engine(db_type, 'us')

    export_tb = "us_aba_rank_2024_tmp"
    export_cols = [
        "id",
        "rank1",
        "rank2",
        "rank3",
        "rank4",
        "rank5",
        "rank6",
        "rank7",
        "rank8",
        "rank9",
        "rank10",
        "rank11",
        "rank12"
    ]

    sh = CommonUtil.build_export_sh(
        site_name='us',
        db_type=db_type,
        hive_tb="tmp_st_rank_to_pg",
        export_tb=export_tb,
        col=export_cols,
        partition_dict={}
    )
    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh, ignore_err=False)
    client.close()
