from elasticsearch import Elasticsearch


class EsUtils(object):
    __es_url_uk_de__ = "http://120.79.147.190:9201"
    __es_url_us_old_month__ = "http://120.79.147.190:9200"
    __es_url__ = "http://192.168.10.217:9200"
    __es_user__ = "elastic"
    __es_passwd__ = "Selection20251#+"
    __basic_auth__ = "ZWxhc3RpYzpzZWxlY3Rpb24yMDIxLis="
    __basic_auth_test__ = "ZWxhc3RpYzpzZWxlY3Rpb24yMDIxLis="
    __es_port__ = '9200'
    __es_ip__ = '192.168.10.217'

    @staticmethod
    # type=0：测试环境,type=1：正式环境
    def get_es_client():
        es_url = EsUtils.__es_url__
        EsUtils.__es_ip__ = str(es_url).split('//')[1].split(':')[0]
        EsUtils.__es_port__ = str(es_url).split('//')[1].split(':')[1]
        client = Elasticsearch(hosts=es_url, http_auth=(EsUtils.__es_user__, EsUtils.__es_passwd__), timeout=60)
        print("工具类创建的client:")
        print(client)
        return client

    # 获取elasticsearch相关配置
    @staticmethod
    def get_es_options(es_index_name, pipeline_id):
        return {
            "es.nodes": EsUtils.__es_ip__,
            "es.port": EsUtils.__es_port__,
            "es.net.http.auth.user": EsUtils.__es_user__,
            "es.net.http.auth.pass": EsUtils.__es_passwd__,
            "es.mapping.id": "asin",
            "es.resource": f"{es_index_name}/_doc",
            "es.batch.write.refresh": "false",
            "es.batch.write.retry.wait": "60s",
            "es.batch.size.entries": "5000",
            "es.nodes.wan.only": "false",
            "es.batch.write.concurrency": "30",
            "es.write.operation": "index",
            "es.ingest.pipeline": f"{pipeline_id}"
        }

    # 获取elasticsearch中索引配置信息
    @staticmethod
    def get_es_body():
        return {
            "settings": {
                "number_of_shards": "3",
                "number_of_replicas": "1",
                "analysis": {
                    "filter": {
                        "en_snowball": {
                            "type": "snowball",
                            "language": "English"
                        },
                        "en_synonym": {
                            "type": "synonym_graph",
                            "synonyms_path": "analysis/synonyms_en.txt",
                            "updateable": "true"
                        }
                    },
                    "analyzer": {
                        "en_analyzer": {
                            "type": "custom",
                            "tokenizer": "standard",
                            "filter": [
                                "lowercase",
                                "en_snowball"
                            ]
                        },
                        "en_search_analyzer": {
                            "tokenizer": "standard",
                            "filter": [
                                "lowercase",
                                "en_synonym",
                                "en_snowball"
                            ]
                        }
                    },
                    "normalizer": {
                        "lowercase_normalizer": {
                            "type": "custom",
                            "char_filter": [],
                            "filter": [
                                "lowercase"
                            ]
                        }
                    }
                }
            },
            "mappings": {
                "properties": {
                    "asin": {
                        "type": "keyword"
                    },
                    "img_url": {
                        "type": "keyword"
                    },
                    "title": {
                        "type": "text",
                        "analyzer": "en_analyzer",
                        "search_analyzer": "en_search_analyzer",
                        "fields": {
                            "keyword": {
                                "ignore_above": 32766,
                                "type": "keyword",
                                "normalizer": "lowercase_normalizer"
                            }
                        }
                    },
                    "title_len": {
                        "type": "integer"
                    },
                    "parent_asin": {
                        "type": "keyword"
                    },
                    "rating": {
                        "type": "float"
                    },
                    "price": {
                        "type": "float"
                    },
                    "total_comments": {
                        "type": "integer"
                    },
                    "buy_box_seller_type": {
                        "type": "short"
                    },
                    "page_inventory": {
                        "type": "short"
                    },
                    "weight": {
                        "type": "float"
                    },
                    "volume": {
                        "type": "keyword"
                    },
                    "ao_val": {
                        "type": "float"
                    },
                    "launch_time": {
                        "type": "date"
                    },
                    "bsr_orders": {
                        "type": "integer"
                    },
                    "bsr_orders_sale": {
                        "type": "double"
                    },
                    "low_star": {
                        "type": "short"
                    },
                    "one_star": {
                        "type": "short"
                    },
                    "two_star": {
                        "type": "short"
                    },
                    "three_star": {
                        "type": "short"
                    },
                    "four_star": {
                        "type": "short"
                    },
                    "five_star": {
                        "type": "short"
                    },
                    "zr_counts": {
                        "type": "integer"
                    },
                    "sp_counts": {
                        "type": "integer"
                    },
                    "sb_counts": {
                        "type": "integer"
                    },
                    "vi_counts": {
                        "type": "integer"
                    },
                    "bs_counts": {
                        "type": "integer"
                    },
                    "ac_counts": {
                        "type": "integer"
                    },
                    "tr_counts": {
                        "type": "integer"
                    },
                    "er_counts": {
                        "type": "integer"
                    },
                    "color": {
                        "type": "text",
                        "analyzer": "standard",
                        "fields": {
                            "keyword": {
                                "ignore_above": 256,
                                "type": "keyword",
                                "normalizer": "lowercase_normalizer"
                            }
                        }
                    },
                    "size": {
                        "type": "text",
                        "analyzer": "standard",
                        "fields": {
                            "keyword": {
                                "ignore_above": 256,
                                "type": "keyword",
                                "normalizer": "lowercase_normalizer"
                            }
                        }
                    },
                    "style": {
                        "type": "text",
                        "analyzer": "standard",
                        "fields": {
                            "keyword": {
                                "ignore_above": 256,
                                "type": "keyword",
                                "normalizer": "lowercase_normalizer"
                            }
                        }
                    },
                    "img_num": {
                        "type": "short"
                    },
                    "img_type": {
                        "type": "keyword"
                    },
                    "activity_type": {
                        "type": "keyword"
                    },
                    "one_two_val": {
                        "type": "float"
                    },
                    "three_four_val": {
                        "type": "float"
                    },
                    "five_six_val": {
                        "type": "float"
                    },
                    "eight_val": {
                        "type": "float"
                    },
                    "together_asin": {
                        "type": "keyword"
                    },
                    "brand": {
                        "type": "text",
                        "analyzer": "standard",
                        "fields": {
                            "keyword": {
                                "ignore_above": 256,
                                "type": "keyword",
                                "normalizer": "lowercase_normalizer"
                            }
                        }
                    },
                    "rank_rise": {
                        "type": "integer"
                    },
                    "rank_change": {
                        "type": "float"
                    },
                    "ao_rise": {
                        "type": "float"
                    },
                    "ao_change": {
                        "type": "float"
                    },
                    "price_rise": {
                        "type": "float"
                    },
                    "price_change": {
                        "type": "float"
                    },
                    "rating_rise": {
                        "type": "float"
                    },
                    "rating_change": {
                        "type": "float"
                    },
                    "comments_rise": {
                        "type": "integer"
                    },
                    "comments_change": {
                        "type": "float"
                    },
                    "bsr_orders_rise": {
                        "type": "integer"
                    },
                    "bsr_orders_change": {
                        "type": "float"
                    },
                    "variation_num": {
                        "type": "integer"
                    },
                    "variation_rise": {
                        "type": "integer"
                    },
                    "variation_change": {
                        "type": "float"
                    },
                    "sales_rise": {
                        "type": "float"
                    },
                    "sales_change": {
                        "type": "float"
                    },
                    "account_id": {
                        "type": "keyword"
                    },
                    "account_name": {
                        "type": "text",
                        "analyzer": "standard",
                        "fields": {
                            "keyword": {
                                "ignore_above": 256,
                                "type": "keyword",
                                "normalizer": "lowercase_normalizer"
                            }
                        }
                    },
                    "site_name": {
                        "type": "keyword"
                    },
                    "site_name_type": {
                        "type": "short"
                    },
                    "launch_time_type": {
                        "type": "short"
                    },
                    "size_type": {
                        "type": "short"
                    },
                    "rank_type": {
                        "type": "short"
                    },
                    "rating_type": {
                        "type": "short"
                    },
                    "price_type": {
                        "type": "short"
                    },
                    "ao_val_type": {
                        "type": "short"
                    },
                    "weight_type": {
                        "type": "short"
                    },
                    "package_quantity": {
                        "type": "long"
                    },
                    "quantity_variation_type": {
                        "type": "short"
                    },
                    "bsr_type": {
                        "type": "short"
                    },
                    "bsr_best_orders_type": {
                        "type": "short"
                    },
                    "is_movie_label": {
                        "type": "short"
                    },
                    "is_brand_label": {
                        "type": "short"
                    },
                    "is_alarm_brand": {
                        "type": "short"
                    },
                    "asin_type": {
                        "type": "short"
                    },
                    "material": {
                        "type": "text",
                        "analyzer": "standard",
                        "fields": {
                            "keyword": {
                                "ignore_above": 256,
                                "type": "keyword",
                                "normalizer": "lowercase_normalizer"
                            }
                        }
                    },
                    "asin_crawl_date": {
                        "type": "date",
                        "format": "yyyy-MM-dd HH:mm:ss"
                    },
                    "category_first_id": {
                        "type": "keyword"
                    },
                    "category_id": {
                        "type": "keyword"
                    },
                    "first_category_rank": {
                        "type": "integer"
                    },
                    "current_category_rank": {
                        "type": "integer"
                    },
                    "asin_weight_ratio": {
                        "type": "float"
                    },
                    "asin_bought_month": {
                        "type": "integer"
                    },
                    "asin_lqs_rating": {
                        "type": "float"
                    },
                    "asin_lqs_rating_detail": {
                        "type": "keyword"
                    },
                    "asin_lob_info": {
                        "type": "keyword"
                    },
                    "is_contains_lob_info": {
                        "type": "short"
                    },
                    "is_package_quantity_abnormal": {
                        "type": "short"
                    },
                    "auctions_num": {
                        "type": "integer"
                    },
                    "auctions_num_all": {
                        "type": "integer"
                    },
                    "skus_num_creat": {
                        "type": "integer"
                    },
                    "skus_num_creat_all": {
                        "type": "integer"
                    },
                    "zr_flow_proportion": {
                        "type": "float"
                    },
                    "matrix_flow_proportion": {
                        "type": "float"
                    },
                    "matrix_ao_val": {
                        "type": "float"
                    },
                    "title_matching_degree": {
                        "type": "float"
                    },
                    "usr_mask_type": {
                        "type": "keyword"
                    },
                    "usr_mask_progress": {
                        "type": "keyword"
                    },
                    "product_features": {
                        "type": "keyword"
                    },
                    "img_info": {
                        "type": "keyword"
                    },
                    "collapse_asin": {
                        "type": "keyword"
                    },
                    "follow_sellers_count": {
                        "type": "integer"
                    },
                    "asin_describe": {
                        "type": "text"
                    },
                    "fbm_price": {
                        "type": "float"
                    }
                }
            }
        }

    #创建索引
    @staticmethod
    def create_index(index_name, client, request_body):
        if not EsUtils.exist_index(index_name=index_name, client=client):
            client.indices.create(index=index_name, body=request_body)
        else:
            print(index_name, "已经存在！！！")

    #删除索引
    @staticmethod
    def delete_index(index_name, client):
        if EsUtils.exist_index(index_name, client):
            client.indices.delete(index=index_name)
        else:
            print(index_name, "索引不存在！！！！")

    #判断索引是否存在
    @staticmethod
    def exist_index(index_name, client):
        return client.indices.exists(index=index_name)

    #索引添加别名
    @staticmethod
    def create_index_alias(index_name, alias_name, client):
        if EsUtils.exist_index(index_name, client) and not EsUtils.exist_index_alias(alias_name, client):
            print("创建成功")
            client.indices.put_alias(index=index_name, name=alias_name)
        else:
            print("无法创建！！！")

    #判断索引的别名是否存在
    @staticmethod
    def exist_index_alias(alias_name, client):
        return client.indices.exists_alias(name=alias_name)

    #判断索别名关联的索引
    @staticmethod
    def get_index_names_associated_alias(alias_name, client):
        index_name_list = []
        alias_info = client.indices.get_alias(name=alias_name)
        if alias_info:
            index_name_list = list(alias_info.keys())
            return index_name_list

    #删除索引别名
    @staticmethod
    def delete_index_alias(alias_name, client):
        if EsUtils.exist_index_alias(alias_name, client):
            index_name_list = EsUtils.get_index_names_associated_alias(alias_name, client)
            if index_name_list:
                for index_name in index_name_list:
                    client.indices.delete_alias(index=index_name, name=alias_name)
                print("索引别名删除完毕！")
        else:
            print("索引别名不存在！")

    @staticmethod
    def user_enrich_pipeline(client, pipeline_id, policy_name1, policy_name2):
        pipeline_body = {
            "description": "asin flow user mask pipeline",
            "processors": [
                {
                    "enrich": {
                        "policy_name": f"{policy_name1}",
                        "field": "asin",
                        "target_field": "policy_add_1",
                        "max_matches": 1,
                        "ignore_missing": True
                    },
                },
                {
                    "enrich": {
                        "policy_name": f"{policy_name2}",
                        "field": "category_id",
                        "target_field": "policy_add_2",
                        "max_matches": 1,
                        "ignore_missing": True
                    },
                },
                {
                    "set": {
                        "field": "usr_mask_type",
                        "value": "{{policy_add_1.usr_mask_type}}",
                        "ignore_empty_value": True
                    }
                },
                {
                    "set": {
                        "field": "usr_mask_progress",
                        "value": "{{policy_add_1.usr_mask_progress}}",
                        "ignore_empty_value": True
                    }
                },
                {
                    "set": {
                        "field": "package_quantity",
                        "value": "{{policy_add_1.package_quantity}}",
                        "ignore_empty_value": True
                    }
                },
                {
                    "set": {
                        "field": "usr_mask_type",
                        "value": "{{policy_add_2.usr_mask_type}}",
                        "ignore_empty_value": True
                    }
                },
                {
                    "remove": {
                        "field": "policy_add_1",
                        "ignore_missing": True
                    }
                },
                {
                    "remove": {
                        "field": "policy_add_2",
                        "ignore_missing": True
                    }
                },
                {
                    "convert": {
                        "field": "package_quantity",
                        "type": "integer",
                        "ignore_missing": True
                    }
                }
            ]
        }
        client.ingest.put_pipeline(id=pipeline_id, body=pipeline_body)

if __name__ == '__main__':
    pass
