/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db.netezza;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetezzaJDBCStatementRunner
extends Thread {
    public static final Log LOG = LogFactory.getLog((String)NetezzaJDBCStatementRunner.class.getName());
    private Connection con;
    private Exception exception;
    private PreparedStatement ps;
    private Thread parent;

    public boolean hasExceptions() {
        return this.exception != null;
    }

    public void printException() {
        if (this.exception != null) {
            LOG.error((Object)"Errors encountered during external table JDBC processing");
            LOG.error((Object)("Exception " + this.exception.getMessage()), (Throwable)this.exception);
        }
    }

    public Throwable getException() {
        if (!this.hasExceptions()) {
            return null;
        }
        return this.exception;
    }

    public NetezzaJDBCStatementRunner(Thread parent, Connection con, String sqlStatement) throws SQLException {
        this.parent = parent;
        this.con = con;
        this.ps = con.prepareStatement(sqlStatement);
        this.exception = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean interruptParent = false;
        try {
            this.ps.execute();
        }
        catch (SQLException sqle) {
            interruptParent = true;
            LOG.error((Object)"Unable to execute external table export", (Throwable)sqle);
            this.exception = sqle;
        }
        finally {
            if (this.con != null) {
                try {
                    this.con.close();
                }
                catch (Exception e) {
                    LOG.debug((Object)("Exception closing connection " + e.getMessage()));
                }
            }
            this.con = null;
        }
        if (interruptParent) {
            this.parent.interrupt();
        }
    }
}

