/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetInputSplit;

public abstract class MainframeDatasetRecordReader<T extends DBWritable>
extends RecordReader<LongWritable, T> {
    private Class<T> inputClass;
    private Configuration conf;
    private MainframeDatasetInputSplit split;
    private LongWritable key;
    private T datasetRecord;
    private long numberRecordRead;
    private int datasetProcessed;
    private static final Log LOG = LogFactory.getLog((String)MainframeDatasetRecordReader.class.getName());

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.split = (MainframeDatasetInputSplit)inputSplit;
        this.conf = taskAttemptContext.getConfiguration();
        this.inputClass = this.conf.getClass("mapreduce.jdbc.input.class", null);
        this.key = null;
        this.datasetRecord = null;
        this.numberRecordRead = 0L;
        this.datasetProcessed = 0;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.key == null) {
            this.key = new LongWritable();
        }
        if (this.datasetRecord == null) {
            this.datasetRecord = (DBWritable)ReflectionUtils.newInstance(this.inputClass, (Configuration)this.conf);
        }
        if (this.getNextRecord(this.datasetRecord)) {
            ++this.numberRecordRead;
            this.key.set(this.numberRecordRead);
            return true;
        }
        return false;
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.datasetRecord;
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.datasetProcessed / (float)this.split.getLength();
    }

    protected String getNextDataset() {
        String datasetName = this.split.getNextDataset();
        if (datasetName != null) {
            ++this.datasetProcessed;
            LOG.info((Object)("Starting transfer of " + datasetName));
        }
        return datasetName;
    }

    protected Configuration getConfiguration() {
        return this.conf;
    }

    protected abstract boolean getNextRecord(T var1) throws IOException;
}

