import json

from utils.datahub_util import build_column_lineages

to_tb = "dwt_bsr_asin_detail"
sources = [
    {
        "form": "dwd_bsr_asin_rank",
        "mappings": [
            ("asin", "asin"),
        ]
    },
    {
        "form": "dim_fd_asin_info",
        "mappings": [
            ("fd_account_name", "account_name"),
        ]
    },
    {
        "form": "dim_cal_asin_history_detail",
        "mappings": [
            ("asin_title", "title"),
            ("asin_img_url", "img_url"),
            ("asin_img_type", "img_type"),
            ("asin_rating", "rating"),
            ("asin_total_comments", "total_comments"),
            ("asin_price", "price"),
            ("asin_weight", "weight"),
            ("asin_launch_time", "launch_time"),
            ("asin_volume", "volume"),
            ("asin_brand_name", "brand_name"),
            ("asin_buy_box_seller_type", "buy_box_seller_type"),
            ("asin_crawl_date", "last_update_time")
        ]
    },
    {
        "form": "dwt_flow_asin",
        "mappings": [
            ("asin_bsr_orders_change", "bsr_orders_change"),
            ("asin_ao_val", "ao_val"),
            ("bsr_orders", "bsr_orders"),
        ]
    },
]

if __name__ == '__main__':
    config = []
    for source in sources:
        for mapping in source["mappings"]:
            config.append(
                {
                    "from": f"{source['form']}.{mapping[0]}",
                    "to": f"{to_tb}.{mapping[1]}",
                },
            )
            pass

    url = build_column_lineages(config)
    print(url)
    pass

pass
