#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh

# 根据site_name来判断数据库名称
if [ $1 == all ]; then
  site_name_array=(us uk de es fr it)
else
  site_name_array=($1)
fi
echo "site_name_array: ${site_name_array}"

date_info=$2

for site_name in ${site_name_array[*]}; do
  if [ ${site_name} == us ]; then
    db=selection
  else
    db=selection_${site_name}
  fi
  echo "db: ${db}"

  # 导入数据
  db_type=mysql
  import_table=${site_name}_bs_category_top100_asin
  hive_table=ods_bs_category_top100_asin
  hdfs_path=/home/big_data_selection/ods/${hive_table}/site_name=${site_name}
  if [ $date_info == all ]; then
    #    全量更新
    query="
      select id,
           asin,
           cate_1_id,
           cate_current_id,
           bsr_rank,
           rating,
           total_comments,
           updated_at,
           date_info
      from ${site_name}_bs_category_top100_asin
      where 1 = 1
        and \$CONDITIONS
"
  else
    #    增量更新
    query="
        select id,
             asin,
             cate_1_id,
             cate_current_id,
             bsr_rank,
             rating,
             total_comments,
             updated_at,
             date_info
        from ${site_name}_bs_category_top100_asin
        where 1 = 1
          and date_info = '${date_info}'
          and \$CONDITIONS
  "
  fi
  echo "执行导入sql如下："
  echo $query
  echo "导入执行中..........."
  import_data
  echo "导入成功！"
done
