/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.lib.RecordParser;
import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.MergeMapperBase;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.ReflectionUtils;

public class MergeTextMapper
extends MergeMapperBase<LongWritable, Text> {
    private SqoopRecord record;

    @Override
    protected void setup(Mapper.Context c) throws IOException, InterruptedException {
        Configuration conf = c.getConfiguration();
        Class recordClass = conf.getClass("sqoop.merge.class", SqoopRecord.class);
        this.record = (SqoopRecord)ReflectionUtils.newInstance((Class)recordClass, (Configuration)conf);
        super.setup(c);
    }

    public void map(LongWritable key, Text val, Mapper.Context c) throws IOException, InterruptedException {
        try {
            this.record.parse(val);
        }
        catch (RecordParser.ParseError pe) {
            throw new IOException(pe);
        }
        this.processRecord(this.record, c);
    }
}

