import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.common_util import CommonUtil
from utils.secure_db_client import get_remote_engine

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    assert site_name is not None, "site_name 不能为空！"

    db_type = 'mysql'
    import_table = f"{site_name}_seller_asin_account"
    sql_query = f"""
        select 
            id,
            account_name,
            asin,
            created_at,
            updated_at,
            seller_id
        from {import_table} 
        where 1=1
        and \$CONDITIONS
    """

    hive_table = "ods_seller_asin_account"
    partition_dict = {
        "site_name": site_name
    }
    hdfs_path = CommonUtil.build_hdfs_path(hive_table, partition_dict=partition_dict)

    if site_name == 'us':
        map_num = 100
    else:
        map_num = 40

    engine = get_remote_engine(
        site_name=site_name,
        db_type=db_type
    )

    engine.sqoop_raw_import(
        query=sql_query,
        hive_table=hive_table,
        hdfs_path=hdfs_path,
        partitions=partition_dict,
        m=map_num,
        split_by='id'
    )

    pass
