import multiprocessing
import os

from gunicorn.glogging import Logger
import logging
from logging.handlers import TimedRotatingFileHandler

#
debug = False
port = 5001
bind = f"0.0.0.0:{port}"
pidfile = "gunicorn.pid"
#  worker数量
workers = min(multiprocessing.cpu_count() * 2 + 1, 16)
worker_class = "gevent"

# 日志
filepath = "/tmp/log/gunicorn_log/"
if not os.path.exists(filepath):
    os.makedirs(filepath)
    pass

th_acc = TimedRotatingFileHandler(when="S", backupCount=7, filename=filepath + "access.log")
th_err = TimedRotatingFileHandler(when="S", backupCount=7, filename=filepath + "error.log")
th_acc.setFormatter(logging.Formatter("[%(asctime)s] %(levelname)s | %(message)s"))
th_err.setFormatter(logging.Formatter("[%(asctime)s] %(levelname)s | %(message)s"))


# gunicorn源码中不支持按日切分日志
class SplitLogger(Logger):
    def __init__(self, cfg):
        super(SplitLogger, self).__init__(cfg)
        self.access_log.addHandler(th_acc)
        self.error_log.addHandler(th_err)


# 超时时间
timeout = 300
graceful_timeout = 300

# 日志位置
loglevel = 'info'
access_log_format = '%(t)s %(p)s %(h)s "%(r)s" %(s)s %(L)s %(b)s %(f)s" "%(a)s"'
accesslog = "/tmp/log/gunicorn_access.log"

error_log_format = '%(t)s %(p)s %(h)s "%(r)s" %(s)s %(L)s %(b)s %(f)s" "%(a)s"'
errorlog = "/tmp/log/gunicorn_debug.log"

# 显示print的代码
capture_output = True
# 是否守护进程
daemon = True
