/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.hive.HiveTypes;
import com.cloudera.sqoop.lib.BlobRef;
import com.cloudera.sqoop.lib.ClobRef;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.manager.SqlManager;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatUtilities;

public abstract class ConnManager {
    public static final Log LOG = LogFactory.getLog((String)SqlManager.class.getName());

    public abstract String[] listDatabases();

    public abstract String[] listTables();

    public abstract String[] getColumnNames(String var1);

    public String[] getColumnNamesForProcedure(String procedureName) {
        throw new UnsupportedOperationException("No stored procedure support for this database");
    }

    public String[] getColumnNamesForQuery(String query) {
        LOG.error((Object)"This database does not support free-form query column names.");
        return null;
    }

    public abstract String getPrimaryKey(String var1);

    public String toJavaType(int sqlType) {
        if (sqlType == 4) {
            return "Integer";
        }
        if (sqlType == 12) {
            return "String";
        }
        if (sqlType == 1) {
            return "String";
        }
        if (sqlType == -1) {
            return "String";
        }
        if (sqlType == -9) {
            return "String";
        }
        if (sqlType == -15) {
            return "String";
        }
        if (sqlType == -16) {
            return "String";
        }
        if (sqlType == 2) {
            return "java.math.BigDecimal";
        }
        if (sqlType == 3) {
            return "java.math.BigDecimal";
        }
        if (sqlType == -7) {
            return "Boolean";
        }
        if (sqlType == 16) {
            return "Boolean";
        }
        if (sqlType == -6) {
            return "Integer";
        }
        if (sqlType == 5) {
            return "Integer";
        }
        if (sqlType == -5) {
            return "Long";
        }
        if (sqlType == 7) {
            return "Float";
        }
        if (sqlType == 6) {
            return "Double";
        }
        if (sqlType == 8) {
            return "Double";
        }
        if (sqlType == 91) {
            return "java.sql.Date";
        }
        if (sqlType == 92) {
            return "java.sql.Time";
        }
        if (sqlType == 93) {
            return "java.sql.Timestamp";
        }
        if (sqlType == -2 || sqlType == -3) {
            return BytesWritable.class.getName();
        }
        if (sqlType == 2005) {
            return ClobRef.class.getName();
        }
        if (sqlType == 2004 || sqlType == -4) {
            return BlobRef.class.getName();
        }
        return null;
    }

    public String toHiveType(int sqlType) {
        return HiveTypes.toHiveType(sqlType);
    }

    public String toHCatType(int sqlType) {
        return SqoopHCatUtilities.toHCatType(sqlType);
    }

    public Schema.Type toAvroType(int sqlType) {
        switch (sqlType) {
            case -6: 
            case 4: 
            case 5: {
                return Schema.Type.INT;
            }
            case -5: {
                return Schema.Type.LONG;
            }
            case -7: 
            case 16: {
                return Schema.Type.BOOLEAN;
            }
            case 7: {
                return Schema.Type.FLOAT;
            }
            case 6: 
            case 8: {
                return Schema.Type.DOUBLE;
            }
            case 2: 
            case 3: {
                return Schema.Type.STRING;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return Schema.Type.STRING;
            }
            case 91: 
            case 92: 
            case 93: {
                return Schema.Type.LONG;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return Schema.Type.BYTES;
            }
        }
        throw new IllegalArgumentException("Cannot convert SQL type " + sqlType);
    }

    public String toJavaType(String tableName, String columnName, int sqlType) {
        return this.toJavaType(sqlType);
    }

    public String toHiveType(String tableName, String columnName, int sqlType) {
        return this.toHiveType(sqlType);
    }

    public Schema.Type toAvroType(String tableName, String columnName, int sqlType) {
        return this.toAvroType(sqlType);
    }

    public abstract Map<String, Integer> getColumnTypes(String var1);

    public Map<String, Integer> getColumnTypesForProcedure(String procedureName) {
        throw new UnsupportedOperationException("No stored procedure support for this database");
    }

    public Map<String, Integer> getColumnTypes(String tableName, String sqlQuery) throws IOException {
        Map<String, Integer> columnTypes;
        if (null != tableName) {
            columnTypes = this.getColumnTypes(tableName);
        } else {
            String query = sqlQuery;
            if (query.indexOf("$CONDITIONS") == -1) {
                throw new IOException("Query [" + query + "] must contain '" + "$CONDITIONS" + "' in WHERE clause.");
            }
            columnTypes = this.getColumnTypesForQuery(query);
        }
        return columnTypes;
    }

    public Map<String, List<Integer>> getColumnInfo(String tableName) {
        throw new UnsupportedOperationException("Get column information is not supported by this manager");
    }

    public Map<String, List<Integer>> getColumnInfoForProcedure(String procedureName) {
        throw new UnsupportedOperationException("No stored procedure support for this database");
    }

    public Map<String, List<Integer>> getColumnInfoForQuery(String query) {
        LOG.error((Object)"This database does not support free-form query column info.");
        return null;
    }

    public Map<String, List<Integer>> getColumnInfo(String tableName, String sqlQuery) throws IOException {
        Map<String, List<Integer>> colInfo;
        if (null != tableName) {
            colInfo = this.getColumnInfo(tableName);
        } else {
            String query = sqlQuery;
            if (query.indexOf("$CONDITIONS") == -1) {
                throw new IOException("Query [" + query + "] must contain '" + "$CONDITIONS" + "' in WHERE clause.");
            }
            colInfo = this.getColumnInfoForQuery(query);
        }
        return colInfo;
    }

    public Map<String, String> getColumnTypeNamesForTable(String tableName) {
        LOG.error((Object)"This database does not support column type names.");
        return null;
    }

    public Map<String, String> getColumnTypeNamesForProcedure(String callName) {
        LOG.error((Object)"This database does not support procedure param type names.");
        return null;
    }

    public Map<String, String> getColumnTypeNamesForQuery(String query) {
        LOG.error((Object)"This database does not support free-form query column type names.");
        return null;
    }

    public Map<String, String> getColumnTypeNames(String tableName, String sqlQuery) {
        return this.getColumnTypeNames(tableName, null, sqlQuery);
    }

    public Map<String, String> getColumnTypeNames(String tableName, String callName, String sqlQuery) {
        Map<String, String> columnTypeNames;
        if (null != tableName) {
            columnTypeNames = this.getColumnTypeNamesForTable(tableName);
        } else if (null != callName) {
            columnTypeNames = this.getColumnTypeNamesForProcedure(callName);
        } else {
            String query = sqlQuery;
            if (query.indexOf("$CONDITIONS") == -1) {
                throw new RuntimeException("Query [" + query + "] must contain '" + "$CONDITIONS" + "' in WHERE clause.");
            }
            columnTypeNames = this.getColumnTypeNamesForQuery(query);
        }
        return columnTypeNames;
    }

    public boolean supportsStagingForExport() {
        return false;
    }

    public long getTableRowCount(String tableName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void deleteAllRecords(String tableName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void migrateData(String fromTable, String toTable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Integer> getColumnTypesForQuery(String query) {
        LOG.error((Object)"This database does not support free-form query column types.");
        return null;
    }

    public abstract ResultSet readTable(String var1, String[] var2) throws SQLException;

    public abstract Connection getConnection() throws SQLException;

    public void discardConnection(boolean doClose) {
        throw new UnsupportedOperationException("No discard connection support for this database");
    }

    public abstract String getDriverClass();

    public abstract void execAndPrint(String var1);

    public abstract void importTable(ImportJobContext var1) throws IOException, ImportException;

    public void importQuery(ImportJobContext context) throws IOException, ImportException {
        throw new ImportException("This database only supports table-based imports.");
    }

    public String escapeColName(String colName) {
        return colName;
    }

    public String escapeTableName(String tableName) {
        return tableName;
    }

    public boolean escapeTableNameOnExport() {
        return false;
    }

    public abstract void close() throws SQLException;

    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        throw new ExportException("This database does not support exports");
    }

    public void callTable(ExportJobContext context) throws IOException, ExportException {
        throw new ExportException("This database does not support exports using stored procedures");
    }

    public void updateTable(ExportJobContext context) throws IOException, ExportException {
        throw new ExportException("This database does not support updates");
    }

    public void upsertTable(ExportJobContext context) throws IOException, ExportException {
        throw new ExportException("Mixed update/insert is not supported against the target database yet");
    }

    public void configureDbOutputColumns(SqoopOptions options) {
        HashSet<String> columns = null;
        if (options.getColumns() != null && options.getColumns().length > 0) {
            columns = new HashSet<String>();
            for (String c : options.getColumns()) {
                columns.add(c.toUpperCase());
            }
        }
        LinkedHashSet<String> updateKeys = new LinkedHashSet<String>();
        HashSet<String> updateKeysUppercase = new HashSet<String>();
        String updateKeyValue = options.getUpdateKeyCol();
        StringTokenizer stok = new StringTokenizer(updateKeyValue, ",");
        while (stok.hasMoreTokens()) {
            String nextUpdateColumn = stok.nextToken().trim();
            if (nextUpdateColumn.length() > 0) {
                String upperCase = nextUpdateColumn.toUpperCase();
                if (columns != null && !columns.contains(upperCase)) {
                    throw new RuntimeException("You must specify all columns from --update-key parameter in --columns parameter.");
                }
                updateKeys.add(nextUpdateColumn);
                updateKeysUppercase.add(upperCase);
                continue;
            }
            throw new RuntimeException("Invalid update key column value specified: '" + updateKeyValue + "'");
        }
        String[] allColNames = this.getColumnNames(options.getTableName());
        ArrayList<String> dbOutCols = new ArrayList<String>();
        for (String col : allColNames) {
            if (updateKeysUppercase.contains(col.toUpperCase()) || columns != null && !columns.contains(col.toUpperCase())) continue;
            dbOutCols.add(col);
        }
        dbOutCols.addAll(updateKeys);
        options.setDbOutputColumns(dbOutCols.toArray(new String[dbOutCols.size()]));
    }

    public abstract void release();

    public Timestamp getCurrentDbTimestamp() {
        LOG.warn((Object)"getCurrentDbTimestamp(): Using local system timestamp.");
        return new Timestamp(System.currentTimeMillis());
    }

    public String timestampToQueryString(Timestamp ts) {
        return "'" + ts + "'";
    }

    public String datetimeToQueryString(String datetime, int columnType) {
        if (columnType != 93 && columnType != 91) {
            String msg = "Column type is neither timestamp nor date!";
            LOG.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return "'" + datetime + "'";
    }

    public String getInputBoundsQuery(String splitByCol, String sanitizedQuery) {
        return null;
    }

    public boolean isORMFacilitySelfManaged() {
        return false;
    }

    public boolean isCharColumn(int columnType) {
        return columnType == 12 || columnType == -9 || columnType == 1 || columnType == -15 || columnType == -1 || columnType == -16;
    }

    public boolean isDirectModeHCatSupported() {
        return false;
    }

    public boolean isDirectModeHBaseSupported() {
        return false;
    }

    public boolean isDirectModeAccumuloSupported() {
        return false;
    }
}

