/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.SQLServerExportDBExecThread;

public class SQLServerUpdateDBExecThread
extends SQLServerExportDBExecThread {
    private static final Log LOG = LogFactory.getLog(SQLServerUpdateDBExecThread.class);
    protected String[] updateCols;

    @Override
    public void initialize(Configuration conf) throws IOException {
        super.initialize(conf);
        String updateKeyColumns = conf.get("sqoop.mapreduce.export.update.col");
        LinkedHashSet<String> updateKeys = new LinkedHashSet<String>();
        StringTokenizer stok = new StringTokenizer(updateKeyColumns, ",");
        while (stok.hasMoreTokens()) {
            String nextUpdateKey = stok.nextToken().trim();
            if (nextUpdateKey.length() > 0) {
                updateKeys.add(nextUpdateKey);
                continue;
            }
            throw new RuntimeException("Invalid update key column value specified: '" + updateKeyColumns + "'");
        }
        this.updateCols = updateKeys.toArray(new String[updateKeys.size()]);
    }

    @Override
    protected PreparedStatement getPreparedStatement(List<SqoopRecord> records) throws SQLException {
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        stmt = conn.prepareStatement(this.getUpdateStatement());
        for (SqoopRecord record : records) {
            record.write(stmt, 0);
            stmt.addBatch();
        }
        return stmt;
    }

    protected String getUpdateStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE " + this.tableName + " SET ");
        boolean first = true;
        for (String col : this.columnNames) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(col);
            sb.append("=?");
            first = false;
        }
        sb.append(" WHERE ");
        first = true;
        for (int i = 0; i < this.updateCols.length; ++i) {
            if (!first) {
                sb.append(" AND ");
            }
            sb.append(this.updateCols[i]).append("=?");
            first = false;
        }
        return sb.toString();
    }
}

