/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util.password;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sqoop.util.password.CredentialProviderHelper;
import org.apache.sqoop.util.password.FilePasswordLoader;

public class CredentialProviderPasswordLoader
extends FilePasswordLoader {
    public static final Log LOG = LogFactory.getLog((String)CredentialProviderPasswordLoader.class.getName());

    @Override
    public String loadPassword(String p, Configuration configuration) throws IOException {
        if (!CredentialProviderHelper.isProviderAvailable()) {
            throw new IOException("CredentialProvider facility not available in the hadoop environment used");
        }
        LOG.debug((Object)("Fetching alias from the specified path: " + p));
        Path path = new Path(p);
        FileSystem fs = path.getFileSystem(configuration);
        this.verifyPath(fs, path);
        String alias = new String(this.readBytes(fs, path));
        String pass = CredentialProviderHelper.resolveAlias(configuration, alias);
        return pass;
    }
}

