import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil
if __name__ == '__main__':
    #  重新计算 nsr榜单数据
    client = SSHUtil.get_ssh_client()
    days = [
        '2023-05-09',
        '2023-05-10',
        '2023-05-11',
        '2023-05-12',
        '2023-05-13',
        '2023-05-14',
        '2023-05-15',
        '2023-05-16',
        '2023-05-17',
        '2023-05-18',
        '2023-05-19',
        '2023-05-22',
        '2023-05-23',
    ]
    for day in days:
        sh = rf""" 
/opt/module/spark/bin/spark-submit  \
--master yarn \
--driver-memory 2g \
--executor-memory 10g \
--executor-cores 4 \
--num-executors 25 \
--queue spark \
/opt/module/spark/demo/py_demo/dwd/dwd_nsr_asin_rank.py us {day}
"""
        SSHUtil.exec_command_async(client, sh, ignore_err=False)

        sh = f"""
/opt/module/anaconda3/envs/pyspark/bin/python3.8 /opt/module/spark/demo/py_demo/sqoop_export/dwd_nsr_asin_rank.py us {day}
        """
        SSHUtil.exec_command_async(client, sh, ignore_err=False)

        pass


    CommonUtil.send_wx_msg(['wujicang'], "提醒", "NSR历史数据重跑成功！！")