
import datetime


class CommonUtil(object):

    @classmethod
    def current_time(cls):
        return int(datetime.datetime.timestamp(datetime.datetime.now()))

    @staticmethod
    def notNone(obj: object = None):
        """
        判断是否是None
        """
        return obj is not None

    @staticmethod
    def listNotNone(listVal:list = None):
        """
        判断是否是空数组
        """
        return listVal is not None and len(listVal) > 0

    @staticmethod
    def notBlank(strVal: str = None):
        """
        判断是否是空字符串
        """
        return strVal is not None and strVal != ''


    @staticmethod
    def get_rel_exception_info():
        import sys
        exc_type, exc_value, exc_traceback = sys.exc_info()
        return exc_type, f"""{exc_value} in {exc_traceback.tb_frame.f_code.co_filename}  {exc_traceback.tb_lineno} line"""


    @staticmethod
    def list_to_insql(arr: list):
        """
        数组转为in中的sql
        :param arr:
        :return:
        """
        return str.join(",", list(map(lambda item: f"'{item}'", arr)))

    @staticmethod
    def date_day_diff(date1: datetime, date2: datetime):
        """
        计算日期差值
        :param date2: datetime
        :param date1: datetime
        :return days
        """
        return (date2 - date1).days


if __name__ == '__main__':
    pass
