#! /bin/env bash

date_type=$2
date_info=$3
hive_table=dim_cal_asin_history_detail
hive_level=dim

if [ $1 == all ];
then
        site_name_array=(uk de es fr it us)
        # site_name_array=(uk de es fr it)
else
        site_name_array=($1)
fi

flag=1

for site_name in ${site_name_array[*]}
	do
		echo "site_name: ${site_name}","date_type: ${date_type}","date_info: ${date_info}"
		echo "hive_table: ${hive_table}"
		# 放到yarn执行-第一部分
		/opt/module/spark/bin/spark-submit \
		--master yarn \
		--driver-memory 4g \
		--executor-memory 10g \
		--executor-cores 4 \
		--num-executors 20 \
		--queue spark \
		/opt/module/spark/demo/py_demo/${hive_level}/${hive_table}_one.py ${site_name} ${date_type} ${date_info}
		sleep 10
		# 删除hdfs数据
		hdfs dfs -rm -r -skipTrash /home/big_data_selection/${hive_level}/${hive_table}/site_name=${site_name}/*
		# 执行第二部分-数据迁移
		/opt/module/spark/bin/spark-submit \
		--master yarn \
		--driver-memory 4g \
		--executor-memory 10g \
		--executor-cores 4 \
		--num-executors 10 \
		--queue spark \
		/opt/module/spark/demo/py_demo/${hive_level}/${hive_table}_two.py ${site_name}
	done

