#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh

# author: huangjian
# usage: 同步各个站点的店铺表的asin详情表
# params: $1-->site_name;$2-->date_type;$3-->date_info
# version: 3.0
# create_date:2022-01-10
# update_date:2022-01-10

date_type=$2
date_info=$3
d1=`echo $date_info | cut -d \- -f 1`
d2=`echo $date_info | cut -d \- -f 2`
#针对一些旧数据week为1不为01这种情况，对入参进行截取后转换为整数
d2=`expr $d2 + 0`

# 根据site_name来判断数据库名称
if [ $1 == all ];
then
	site_name_array=(us uk de es fr it)
else
	site_name_array=($1)
fi
echo "site_name_array: ${site_name_array}"



for site_name in ${site_name_array[*]}
    do
		echo 1. 当前连接的mysql数据库站点: ${site_name}
		if [ $site_name == us ];
		then
			db=selection
		else
			db=selection_$site_name
		fi
		echo "db: ${db}"
		improt_table=${site_name}_asin_detail_product_${d1}
		echo "improt_table:${import_table}"
		echo 2. 先删除已经存在的分区
		hive_table=ods_asin_detail_product
		hdfs_path="/home/big_data_selection/ods/${hive_table}/site_name=${site_name}/date_type=${date_type}/date_info=${date_info}"
		hdfs dfs -rm -r ${hdfs_path}/*
		echo 3. 导入数据
		query="select id,account_id,asin,title,img_url,price,rating,total_comments,week,row_num,created_at,updated_at from ${improt_table} where week=${d2} and \$CONDITIONS"
		echo ${query}
		import_data
	done
