#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh


if [ $1 == all ];
then
site_name_array=(us uk de es fr it)
else
site_name_array=($1)
fi


date_type=$2
date_info=$3
d1=`echo $date_info | cut -d \- -f 1`
d2=`echo $date_info | cut -d \- -f 2`


for site_name in ${site_name_array[*]}
do
	if [ $site_name == us ];
	then
		db=selection
	else
		db=selection_$site_name
	fi
	
	cols="id,search_term,rank,asin1,product_title1,click_share1,conversion_share1,asin2,product_title2,click_share2,conversion_share2,asin3,product_title3,click_share3,conversion_share3,created_time,updated_time,quantity_being_sold"
	if [ $date_type == 'day' ]
	then
		cols="id,search_term,rank,asin1,null as product_title1,click_share1,conversion_share1,asin2,null as product_title2,click_share2,conversion_share2,asin3,null as product_title3,click_share3,conversion_share3,created_time,updated_time,null as quantity_being_sold"
		d3=`echo $date_info | cut -d \- -f 3`
		import_table=${site_name}_brand_analytics_everyday_${d1}_${d2}_${d3}
		db_type=postgresql
		query="select ${cols} from ${import_table} where 1=1 and \$CONDITIONS"
	elif [ $date_type == 'week' ]
	then
		import_table=${site_name}_brand_analytics_${d1}
		db_type=mysql
                query="select ${cols} from ${import_table} where ${date_type}=${d2} and \$CONDITIONS"
	elif [ $date_type == 'month' ]
	then
		import_table=${site_name}_brand_analytics_${date_type}
		db_type=mysql
                query="select ${cols} from ${import_table} where year=${d1} and ${date_type}=${d2} and \$CONDITIONS"
	elif [ $date_type == 'quarter' ]
        then
                import_table=${site_name}_brand_analytics_${date_type}
		db_type=mysql
                query="select ${cols} from ${import_table} where year=${d1} and ${date_type}=${d2} and \$CONDITIONS"
	else
		echo 输入类型错误
	fi
		echo cols:${cols}, date_type:${date_type}, query:${query}
	queue=spark
	hive_table=ods_brand_analytics
	hdfs_path=/home/big_data_selection/ods/${hive_table}/site_name=${site_name}/date_type=${date_type}/date_info=${date_info}
	import_data
done
