#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh

# author: ffman
# usage: 同步各个站点的店铺表的asin详情表
# params: 参数1:site_name;参数2:date_type;参数3:date_info;
# version: 2.0
# create_date:2022-3-15
# update_date:2022-11-02



# 定义脚本传入的变量
date_type=$2
date_info=$3
d1=`echo $date_info | cut -d \- -f 1`
d2=`echo $date_info | cut -d \- -f 2`

# 根据site_name来判断数据库名称
if [ $1 == all ];
then
        site_name_array=(us uk de es fr it)
else
        site_name_array=($1)
fi
echo "site_name_array: ${site_name_array}"


for site_name in ${site_name_array[*]}
    do
                echo 1. 当前连接的mysql数据库站点: ${site_name}
                if [ $site_name == us ];
                then
                        db=selection
                else
                        db=selection_$site_name
                fi
                echo "db: ${db}"
                echo 2. 先删除已经存在的分区
                hive_table=ods_seller_account_feedback_report
                hdfs_path="/home/big_data_selection/ods/${hive_table}/site_name=${site_name}/date_type=${date_type}/date_info=${date_info}"
                hdfs dfs -rm -r ${hdfs_path}/*
                echo 3. 导入数据
                mysql_table=${site_name}_seller_account_feedback_report
				cols="id,ym as 'year_month',account_id,account_name,site_name as country_name,count_30_day,count_30_day_rate,count_1_year,count_lifetime,count_lifetime_rate,num,num_new,created_at,updated_at"
				query="select ${cols} from ${mysql_table} where ym='${d1}_${d2}' and \$CONDITIONS"
				maps=1
                import_data
     done
