#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh

if [ $1 == all ];
then
site_name_array=(us uk de es fr it)
else
site_name_array=($1)
fi


for site_name in ${site_name_array[*]}
	do
		if [ $site_name == us ];
		then
			db=selection
		else
			db=selection_$site_name
		fi
		# 导入数据
		import_table=${site_name}_rank_flow
		hive_table=ods_rank_flow
		db_type=mysql
		hdfs_path=/home/big_data_selection/ods/${hive_table}/site_name=${site_name}
		cols="id,rank,flow,created_time,updated_time"
		query="select ${cols} from ${import_table} where 1=1 and \$CONDITIONS"
		import_data
	done
