/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.DefaultManagerFactory;
import com.cloudera.sqoop.manager.ManagerFactory;
import com.cloudera.sqoop.metastore.JobData;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.manager.GenericJdbcManager;
import org.apache.sqoop.manager.oracle.OraOopManagerFactory;

public class ConnFactory {
    public static final Log LOG = LogFactory.getLog((String)ConnFactory.class.getName());
    public static final String FACTORY_CLASS_NAMES_KEY = "sqoop.connection.factories";
    public static final String[] DEFAULT_FACTORY_CLASS_NAMES_ARR = new String[]{OraOopManagerFactory.class.getName(), DefaultManagerFactory.class.getName()};
    public static final String DEFAULT_FACTORY_CLASS_NAMES = StringUtils.arrayToString((String[])DEFAULT_FACTORY_CLASS_NAMES_ARR);
    private List<ManagerFactory> factories = new LinkedList<ManagerFactory>();

    public ConnFactory(Configuration conf) {
        this.instantiateFactories(conf);
    }

    private void instantiateFactories(Configuration conf) {
        String[] classNameArray;
        this.loadManagersFromConfDir(conf);
        for (String className : classNameArray = conf.getStrings(FACTORY_CLASS_NAMES_KEY, DEFAULT_FACTORY_CLASS_NAMES_ARR)) {
            try {
                className = className.trim();
                ManagerFactory factory = (ManagerFactory)ReflectionUtils.newInstance((Class)conf.getClassByName(className), (Configuration)conf);
                LOG.debug((Object)("Loaded manager factory: " + className));
                this.factories.add(factory);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error((Object)("Could not load ManagerFactory " + className + " (not found)"));
            }
        }
    }

    public ConnManager getManager(JobData data) throws IOException {
        SqoopOptions options = data.getSqoopOptions();
        String manualDriver = options.getDriverClassName();
        String managerClassName = options.getConnManagerClassName();
        if (manualDriver != null && managerClassName == null) {
            LOG.warn((Object)("Parameter --driver is set to an explicit driver however appropriate connection manager is not being set (via --connection-manager). Sqoop is going to fall back to " + GenericJdbcManager.class.getCanonicalName() + ". Please specify" + " explicitly which connection manager should be used next time."));
            return new GenericJdbcManager(manualDriver, options);
        }
        if (managerClassName != null) {
            ConnManager connManager = null;
            try {
                Class<?> cls = Class.forName(managerClassName);
                if (manualDriver == null) {
                    Constructor<?> constructor = cls.getDeclaredConstructor(SqoopOptions.class);
                    connManager = (ConnManager)constructor.newInstance(options);
                } else {
                    Constructor<?> constructor = cls.getDeclaredConstructor(String.class, SqoopOptions.class);
                    connManager = (ConnManager)constructor.newInstance(manualDriver, options);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Sqoop could not found specified connection manager class " + managerClassName + ". Please check that you've specified the " + "class correctly."));
                throw new IOException(e);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Object)"Sqoop wasn't able to create connnection manager properly. Some of the connectors supports explicit --driver and some do not. Please try to either specify --driver or leave it out.");
                throw new IOException(e);
            }
            catch (Exception e) {
                LOG.error((Object)("Problem with bootstrapping connector manager:" + managerClassName));
                LOG.error((Object)e);
                throw new IOException(e);
            }
            return connManager;
        }
        for (ManagerFactory factory : this.factories) {
            LOG.debug((Object)("Trying ManagerFactory: " + factory.getClass().getName()));
            ConnManager mgr = factory.accept(data);
            if (null == mgr) continue;
            LOG.debug((Object)("Instantiated ConnManager " + mgr.toString()));
            return mgr;
        }
        throw new IOException("No manager for connect string: " + data.getSqoopOptions().getConnectString());
    }

    private void addManager(Configuration conf, String factory) {
        String curVal = conf.get(FACTORY_CLASS_NAMES_KEY);
        if (null == curVal) {
            conf.set(FACTORY_CLASS_NAMES_KEY, factory);
        } else {
            conf.set(FACTORY_CLASS_NAMES_KEY, curVal + "," + factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addManagersFromFile(Configuration conf, File f) {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            Properties props = new Properties();
            props.load(r);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String factory = entry.getKey().toString();
                this.addManager(conf, factory);
                String jarName = entry.getValue().toString();
                if (jarName.length() > 0) {
                    ClassLoaderStack.addJarFile(jarName, factory);
                    LOG.debug((Object)("Added factory " + factory + " in jar " + jarName + " specified by " + f));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Added factory " + factory + " specified by " + f));
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)("Error loading ManagerFactory information from file " + f + ": " + StringUtils.stringifyException((Throwable)ioe)));
        }
        finally {
            if (null != r) {
                try {
                    r.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Error closing file " + f + ": " + ioe));
                }
            }
        }
    }

    private Configuration loadManagersFromConfDir(Configuration conf) {
        if (conf.get(FACTORY_CLASS_NAMES_KEY) != null) {
            LOG.debug((Object)"sqoop.connection.factories is set; ignoring managers.d");
            return conf;
        }
        String confDirName = System.getenv("SQOOP_CONF_DIR");
        if (null == confDirName) {
            LOG.warn((Object)"$SQOOP_CONF_DIR has not been set in the environment. Cannot check for additional configuration.");
            return conf;
        }
        File confDir = new File(confDirName);
        File mgrDir = new File(confDir, "managers.d");
        if (mgrDir.exists() && mgrDir.isDirectory()) {
            Object[] fileNames;
            try {
                fileNames = mgrDir.list();
            }
            catch (SecurityException e) {
                fileNames = null;
            }
            if (null == fileNames) {
                LOG.warn((Object)"Sqoop cannot read $SQOOP_CONF_DIR/managers.d. Please check the permissions on managers.d.");
                return conf;
            }
            Arrays.sort(fileNames);
            for (Object fileName : fileNames) {
                File f = new File(mgrDir, (String)fileName);
                if (!f.isFile()) continue;
                this.addManagersFromFile(conf, f);
            }
            this.addManager(conf, DEFAULT_FACTORY_CLASS_NAMES);
        }
        conf.setClassLoader(Thread.currentThread().getContextClassLoader());
        return conf;
    }
}

