/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.avro;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.io.BytesWritable;
import org.apache.sqoop.lib.BlobRef;
import org.apache.sqoop.lib.ClobRef;

public final class AvroUtil {
    private static final String TIMESTAMP_TYPE = "java.sql.Timestamp";
    private static final String TIME_TYPE = "java.sql.Time";
    private static final String DATE_TYPE = "java.sql.Date";
    private static final String BIG_DECIMAL_TYPE = "java.math.BigDecimal";
    private static final String BLOB_REF_TYPE = "com.cloudera.sqoop.lib.BlobRef";

    public static Object toAvro(Object o, boolean bigDecimalFormatString) {
        if (o instanceof BigDecimal) {
            if (bigDecimalFormatString) {
                return ((BigDecimal)o).toPlainString();
            }
            return o.toString();
        }
        if (o instanceof Date) {
            return ((Date)o).getTime();
        }
        if (o instanceof Time) {
            return ((Time)o).getTime();
        }
        if (o instanceof Timestamp) {
            return ((Timestamp)o).getTime();
        }
        if (o instanceof BytesWritable) {
            BytesWritable bw = (BytesWritable)o;
            return ByteBuffer.wrap(bw.getBytes(), 0, bw.getLength());
        }
        if (o instanceof BlobRef) {
            BlobRef br = (BlobRef)o;
            byte[] bytes = br.isExternal() ? br.toString().getBytes() : (byte[])br.getData();
            return ByteBuffer.wrap(bytes);
        }
        if (o instanceof ClobRef) {
            throw new UnsupportedOperationException("ClobRef not supported");
        }
        return o;
    }

    public static String toAvroColumn(String column) {
        return AvroUtil.toAvroIdentifier(column);
    }

    public static String toAvroIdentifier(String candidate) {
        String formattedCandidate = candidate.replaceAll("\\W+", "");
        if (formattedCandidate.substring(0, 1).matches("[a-zA-Z_]")) {
            return formattedCandidate;
        }
        return "AVRO_" + formattedCandidate;
    }

    public static GenericRecord toGenericRecord(Map<String, Object> fieldMap, Schema schema, boolean bigDecimalFormatString) {
        GenericData.Record record = new GenericData.Record(schema);
        for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
            Object avroObject = AvroUtil.toAvro(entry.getValue(), bigDecimalFormatString);
            String avroColumn = AvroUtil.toAvroColumn(entry.getKey());
            record.put(avroColumn, avroObject);
        }
        return record;
    }

    public static Object fromAvro(Object avroObject, Schema schema, String type) {
        if (avroObject == null) {
            return null;
        }
        switch (schema.getType()) {
            case NULL: {
                return null;
            }
            case BOOLEAN: 
            case INT: 
            case FLOAT: 
            case DOUBLE: {
                return avroObject;
            }
            case LONG: {
                if (type.equals(DATE_TYPE)) {
                    return new Date((Long)avroObject);
                }
                if (type.equals(TIME_TYPE)) {
                    return new Time((Long)avroObject);
                }
                if (type.equals(TIMESTAMP_TYPE)) {
                    return new Timestamp((Long)avroObject);
                }
                return avroObject;
            }
            case BYTES: {
                ByteBuffer bb = (ByteBuffer)avroObject;
                BytesWritable bw = new BytesWritable();
                bw.set(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
                if (type.equals(BLOB_REF_TYPE)) {
                    throw new UnsupportedOperationException("BlobRef not supported");
                }
                return bw;
            }
            case STRING: {
                if (type.equals(BIG_DECIMAL_TYPE)) {
                    return new BigDecimal(avroObject.toString());
                }
                if (type.equals(DATE_TYPE)) {
                    return Date.valueOf(avroObject.toString());
                }
                if (type.equals(TIME_TYPE)) {
                    return Time.valueOf(avroObject.toString());
                }
                if (type.equals(TIMESTAMP_TYPE)) {
                    return Timestamp.valueOf(avroObject.toString());
                }
                return avroObject.toString();
            }
            case ENUM: {
                return avroObject.toString();
            }
            case UNION: {
                List types = schema.getTypes();
                if (types.size() != 2) {
                    throw new IllegalArgumentException("Only support union with null");
                }
                Schema s1 = (Schema)types.get(0);
                Schema s2 = (Schema)types.get(1);
                if (s1.getType() == Schema.Type.NULL) {
                    return AvroUtil.fromAvro(avroObject, s2, type);
                }
                if (s2.getType() == Schema.Type.NULL) {
                    return AvroUtil.fromAvro(avroObject, s1, type);
                }
                throw new IllegalArgumentException("Only support union with null");
            }
            case FIXED: {
                return new BytesWritable(((GenericFixed)avroObject).bytes());
            }
        }
        throw new IllegalArgumentException("Cannot convert Avro type " + schema.getType());
    }
}

