/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.lib;

import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.lib.RecordParser;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;

public class RecordParser {
    public static final Log LOG = LogFactory.getLog((String)RecordParser.class.getName());
    private DelimiterSet delimiters;
    private ArrayList<String> outputs;

    public RecordParser(DelimiterSet delimitersIn) {
        this.delimiters = delimitersIn.copy();
        this.outputs = new ArrayList();
    }

    public List<String> parseRecord(CharSequence input) throws RecordParser.ParseError {
        if (null == input) {
            throw new RecordParser.ParseError("null input string");
        }
        return this.parseRecord(CharBuffer.wrap(input));
    }

    public List<String> parseRecord(Text input) throws RecordParser.ParseError {
        if (null == input) {
            throw new RecordParser.ParseError("null input string");
        }
        return this.parseRecord(input.toString());
    }

    public List<String> parseRecord(byte[] input) throws RecordParser.ParseError {
        if (null == input) {
            throw new RecordParser.ParseError("null input string");
        }
        return this.parseRecord(ByteBuffer.wrap(input).asCharBuffer());
    }

    public List<String> parseRecord(char[] input) throws RecordParser.ParseError {
        if (null == input) {
            throw new RecordParser.ParseError("null input string");
        }
        return this.parseRecord(CharBuffer.wrap(input));
    }

    public List<String> parseRecord(ByteBuffer input) throws RecordParser.ParseError {
        if (null == input) {
            throw new RecordParser.ParseError("null input string");
        }
        return this.parseRecord(input.asCharBuffer());
    }

    public List<String> parseRecord(CharBuffer input) throws RecordParser.ParseError {
        if (null == input) {
            throw new RecordParser.ParseError("null input string");
        }
        char curChar = '\u0000';
        ParseState state = ParseState.FIELD_START;
        int len = input.length();
        StringBuilder sb = null;
        this.outputs.clear();
        char enclosingChar = this.delimiters.getEnclosedBy();
        char fieldDelim = this.delimiters.getFieldsTerminatedBy();
        char recordDelim = this.delimiters.getLinesTerminatedBy();
        char escapeChar = this.delimiters.getEscapedBy();
        boolean enclosingRequired = this.delimiters.isEncloseRequired();
        block8: for (int pos = 0; pos < len; ++pos) {
            curChar = input.get();
            switch (state) {
                case FIELD_START: {
                    if (null != sb) {
                        this.outputs.add(sb.toString());
                    }
                    sb = new StringBuilder();
                    if (enclosingChar == curChar) {
                        state = ParseState.ENCLOSED_FIELD;
                        continue block8;
                    }
                    if (escapeChar == curChar) {
                        state = ParseState.UNENCLOSED_ESCAPE;
                        continue block8;
                    }
                    if (fieldDelim == curChar) continue block8;
                    if (recordDelim == curChar) {
                        pos = len;
                        continue block8;
                    }
                    state = ParseState.UNENCLOSED_FIELD;
                    sb.append(curChar);
                    if (!enclosingRequired) continue block8;
                    throw new RecordParser.ParseError("Opening field-encloser expected at position " + pos);
                }
                case ENCLOSED_FIELD: {
                    if (escapeChar == curChar) {
                        state = ParseState.ENCLOSED_ESCAPE;
                        continue block8;
                    }
                    if (enclosingChar == curChar) {
                        state = ParseState.ENCLOSED_EXPECT_DELIMITER;
                        continue block8;
                    }
                    sb.append(curChar);
                    continue block8;
                }
                case UNENCLOSED_FIELD: {
                    if (escapeChar == curChar) {
                        state = ParseState.UNENCLOSED_ESCAPE;
                        continue block8;
                    }
                    if (fieldDelim == curChar) {
                        state = ParseState.FIELD_START;
                        continue block8;
                    }
                    if (recordDelim == curChar) {
                        pos = len;
                        continue block8;
                    }
                    sb.append(curChar);
                    continue block8;
                }
                case ENCLOSED_ESCAPE: {
                    sb.append(curChar);
                    state = ParseState.ENCLOSED_FIELD;
                    continue block8;
                }
                case ENCLOSED_EXPECT_DELIMITER: {
                    if (fieldDelim == curChar) {
                        state = ParseState.FIELD_START;
                        continue block8;
                    }
                    if (recordDelim == curChar) {
                        pos = len;
                        continue block8;
                    }
                    throw new RecordParser.ParseError("Expected delimiter at position " + pos);
                }
                case UNENCLOSED_ESCAPE: {
                    sb.append(curChar);
                    state = ParseState.UNENCLOSED_FIELD;
                    continue block8;
                }
                default: {
                    throw new RecordParser.ParseError("Unexpected parser state: " + (Object)((Object)state));
                }
            }
        }
        if (state == ParseState.FIELD_START && curChar == fieldDelim && null != sb) {
            this.outputs.add(sb.toString());
            sb = new StringBuilder();
        }
        if (null != sb) {
            this.outputs.add(sb.toString());
        }
        return this.outputs;
    }

    public boolean isEnclosingRequired() {
        return this.delimiters.isEncloseRequired();
    }

    public String toString() {
        return "RecordParser[" + this.delimiters.toString() + "]";
    }

    public int hashCode() {
        return this.delimiters.hashCode();
    }

    public static class ParseError
    extends Exception {
        public ParseError() {
            super("ParseError");
        }

        public ParseError(String msg) {
            super(msg);
        }

        public ParseError(String msg, Throwable cause) {
            super(msg, cause);
        }

        public ParseError(Throwable cause) {
            super(cause);
        }
    }

    private static enum ParseState {
        FIELD_START,
        ENCLOSED_FIELD,
        UNENCLOSED_FIELD,
        ENCLOSED_ESCAPE,
        ENCLOSED_EXPECT_DELIMITER,
        UNENCLOSED_ESCAPE;

    }
}

