/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.AutoProgressMapper;
import com.cloudera.sqoop.orm.ClassWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.avro.AvroUtil;

public class GenericRecordExportMapper<K, V>
extends AutoProgressMapper<K, V, SqoopRecord, NullWritable> {
    public static final String AVRO_COLUMN_TYPES_MAP = "sqoop.avro.column.types.map";
    protected MapWritable columnTypes;
    private SqoopRecord recordImpl;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        String recordClassName = conf.get("sqoop.mapreduce.export.table.class");
        if (null == recordClassName) {
            throw new IOException("Export table class name (sqoop.mapreduce.export.table.class) is not set!");
        }
        try {
            Class<?> cls = Class.forName(recordClassName, true, Thread.currentThread().getContextClassLoader());
            this.recordImpl = (SqoopRecord)ReflectionUtils.newInstance(cls, (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        if (null == this.recordImpl) {
            throw new IOException("Could not instantiate object of type " + recordClassName);
        }
        this.columnTypes = (MapWritable)DefaultStringifier.load((Configuration)conf, (String)AVRO_COLUMN_TYPES_MAP, MapWritable.class);
    }

    protected SqoopRecord toSqoopRecord(GenericRecord record) throws IOException {
        Schema avroSchema = record.getSchema();
        for (Map.Entry e : this.columnTypes.entrySet()) {
            String columnName = ((Writable)e.getKey()).toString();
            String columnType = ((Writable)e.getValue()).toString();
            String cleanedCol = ClassWriter.toIdentifier(columnName);
            Schema.Field field = GenericRecordExportMapper.getFieldIgnoreCase(avroSchema, cleanedCol);
            if (null == field) {
                throw new IOException("Cannot find field " + cleanedCol + " in Avro schema " + avroSchema);
            }
            Object avroObject = record.get(field.name());
            Object fieldVal = AvroUtil.fromAvro(avroObject, field.schema(), columnType);
            this.recordImpl.setField(cleanedCol, fieldVal);
        }
        return this.recordImpl;
    }

    private static Schema.Field getFieldIgnoreCase(Schema avroSchema, String fieldName) {
        for (Schema.Field field : avroSchema.getFields()) {
            if (!field.name().equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        return null;
    }
}

