import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.common_util import CommonUtil
from utils.secure_db_client import get_remote_engine

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    assert site_name is not None, "site_name 不能为空！"

    db_type = "mysql"
    import_tb = f"{site_name}_bs_category"
    query = f"""
        select 
            id,
            p_id,
            ch_name,
            en_name,
            nodes_num,
            path,
            is_show,
            one_category_id,
            and_en_name,
            leaf_node,
            delete_time,
            full_name,
            category_id,
            category_parent_id,
            category_first_id,
            category_state,
            redirect_flag,
            redirect_first_id,
            created_at,
            updated_at 
        from {import_tb}
        where 1 = 1
        and \$CONDITIONS
    """

    hive_tb = "ods_bs_category"
    partition_dict = {
        "site_name": site_name,
    }
    hdfs_path = CommonUtil.build_hdfs_path(hive_tb, partition_dict=partition_dict)

    engine = get_remote_engine(
        site_name=site_name,
        db_type=db_type
    )

    engine.sqoop_raw_import(
        query=query,
        hive_table=hive_tb,
        hdfs_path=hdfs_path,
        partitions=partition_dict
    )

    pass
