/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.GenericJdbcManager;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.ExportBatchOutputFormat;
import com.cloudera.sqoop.mapreduce.JdbcExportJob;
import com.cloudera.sqoop.mapreduce.JdbcUpsertExportJob;
import com.cloudera.sqoop.mapreduce.OracleUpsertOutputFormat;
import com.cloudera.sqoop.mapreduce.db.OracleDataDrivenDBInputFormat;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.util.LoggingUtils;

public class OracleManager
extends GenericJdbcManager {
    public static final Log LOG = LogFactory.getLog((String)OracleManager.class.getName());
    public static final int ERROR_TABLE_OR_VIEW_DOES_NOT_EXIST = 942;
    public static final String QUERY_LIST_DATABASES = "SELECT USERNAME FROM DBA_USERS";
    public static final String QUERY_LIST_TABLES = "SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER = ?";
    public static final String QUERY_COLUMNS_FOR_TABLE = "SELECT COLUMN_NAME FROM ALL_TAB_COLUMNS WHERE OWNER = ? AND TABLE_NAME = ? ORDER BY COLUMN_ID";
    public static final String QUERY_PRIMARY_KEY_FOR_TABLE = "SELECT ALL_CONS_COLUMNS.COLUMN_NAME FROM ALL_CONS_COLUMNS, ALL_CONSTRAINTS WHERE ALL_CONS_COLUMNS.CONSTRAINT_NAME = ALL_CONSTRAINTS.CONSTRAINT_NAME AND ALL_CONSTRAINTS.CONSTRAINT_TYPE = 'P' AND ALL_CONS_COLUMNS.TABLE_NAME = ? AND ALL_CONS_COLUMNS.OWNER = ?";
    public static final String QUERY_GET_SESSIONUSER = "SELECT USER FROM DUAL";
    private static final String DRIVER_CLASS = "oracle.jdbc.OracleDriver";
    public static final String ORACLE_TIMEZONE_KEY = "oracle.sessionTimeZone";
    private static final ConnCache CACHE = new ConnCache();
    private Map<String, String> columnTypeNames;

    public OracleManager(SqoopOptions opts) {
        super(DRIVER_CLASS, opts);
    }

    @Override
    public void close() throws SQLException {
        this.release();
        if (this.hasOpenConnection()) {
            CACHE.recycle(this.options.getConnectString(), this.options.getUsername(), this.getConnection());
            this.discardConnection(false);
        }
    }

    @Override
    protected String getColNamesQuery(String tableName) {
        String query = "SELECT t.* FROM " + this.escapeTableName(tableName) + " t WHERE 1=0";
        LOG.debug((Object)("Using column names query: " + query));
        return query;
    }

    @Override
    protected Connection makeConnection() throws SQLException {
        Connection connection;
        String driverClass = this.getDriverClass();
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not load db driver class: " + driverClass);
        }
        String username = this.options.getUsername();
        String password = this.options.getPassword();
        String connectStr = this.options.getConnectString();
        try {
            connection = CACHE.getConnection(connectStr, username);
        }
        catch (SQLException e) {
            connection = null;
            LOG.debug((Object)"Cached connecion has expired.");
        }
        if (null == connection) {
            LOG.debug((Object)("Creating a new connection for " + connectStr + ", using username: " + username));
            Properties connectionParams = this.options.getConnectionParams();
            if (connectionParams != null && connectionParams.size() > 0) {
                LOG.debug((Object)"User specified connection params. Using properties specific API for making connection.");
                Properties props = new Properties();
                if (username != null) {
                    props.put("user", username);
                }
                if (password != null) {
                    props.put("password", password);
                }
                props.putAll((Map<?, ?>)connectionParams);
                connection = DriverManager.getConnection(connectStr, props);
            } else {
                LOG.debug((Object)"No connection paramenters specified. Using regular API for making connection.");
                connection = username == null ? DriverManager.getConnection(connectStr) : DriverManager.getConnection(connectStr, username, password);
            }
        }
        connection.setTransactionIsolation(2);
        this.setSessionTimeZone(connection);
        connection.setAutoCommit(false);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSessionUser(Connection conn) {
        Statement stmt = null;
        ResultSet rset = null;
        String user = null;
        try {
            stmt = conn.createStatement(1003, 1007);
            rset = stmt.executeQuery(QUERY_GET_SESSIONUSER);
            if (rset.next()) {
                user = rset.getString(1);
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Failed to rollback transaction", ex);
            }
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close statement", ex);
                }
            }
        }
        if (user == null) {
            throw new RuntimeException("Unable to get current session user");
        }
        return user;
    }

    private void setSessionTimeZone(Connection conn) throws SQLException {
        Method method;
        try {
            method = conn.getClass().getMethod("setSessionTimeZone", String.class);
        }
        catch (Exception ex) {
            LOG.error((Object)("Could not find method setSessionTimeZone in " + conn.getClass().getName()), (Throwable)ex);
            throw new SQLException(ex);
        }
        String clientTimeZoneStr = this.options.getConf().get(ORACLE_TIMEZONE_KEY, "GMT");
        try {
            method.setAccessible(true);
            method.invoke((Object)conn, clientTimeZoneStr);
            LOG.info((Object)("Time zone has been set to " + clientTimeZoneStr));
        }
        catch (Exception ex) {
            LOG.warn((Object)("Time zone " + clientTimeZoneStr + " could not be set on Oracle database."));
            LOG.info((Object)"Setting default time zone: GMT");
            try {
                method.invoke((Object)conn, "GMT");
            }
            catch (Exception ex2) {
                LOG.error((Object)"Could not set time zone for oracle connection", (Throwable)ex2);
                throw new SQLException(ex);
            }
        }
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        context.setConnManager(this);
        context.setInputFormat(OracleDataDrivenDBInputFormat.class);
        super.importTable(context);
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        JdbcExportJob exportJob = new JdbcExportJob(context, null, null, ExportBatchOutputFormat.class);
        exportJob.runExport();
    }

    @Override
    public void upsertTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        JdbcUpsertExportJob exportJob = new JdbcUpsertExportJob(context, OracleUpsertOutputFormat.class);
        exportJob.runExport();
    }

    @Override
    public void configureDbOutputColumns(SqoopOptions options) {
        if (options.getUpdateMode() == SqoopOptions.UpdateMode.UpdateOnly) {
            super.configureDbOutputColumns(options);
        } else {
            LinkedHashSet<String> updateKeys = new LinkedHashSet<String>();
            HashSet<String> updateKeysUppercase = new HashSet<String>();
            String updateKeyValue = options.getUpdateKeyCol();
            StringTokenizer stok = new StringTokenizer(updateKeyValue, ",");
            while (stok.hasMoreTokens()) {
                String nextUpdateColumn = stok.nextToken().trim();
                if (nextUpdateColumn.length() > 0) {
                    updateKeys.add(nextUpdateColumn);
                    updateKeysUppercase.add(nextUpdateColumn.toUpperCase());
                    continue;
                }
                throw new RuntimeException("Invalid update key column value specified: '" + updateKeyValue + "'");
            }
            String[] allColNames = this.getColumnNames(options.getTableName());
            ArrayList<String> dbOutCols = new ArrayList<String>();
            dbOutCols.addAll(updateKeys);
            for (String col : allColNames) {
                if (updateKeysUppercase.contains(col.toUpperCase())) continue;
                dbOutCols.add(col);
            }
            for (String col : allColNames) {
                dbOutCols.add(col);
            }
            options.setDbOutputColumns(dbOutCols.toArray(new String[dbOutCols.size()]));
        }
    }

    @Override
    public ResultSet readTable(String tableName, String[] columns) throws SQLException {
        if (columns == null) {
            columns = this.getColumnNames(tableName);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        boolean first = true;
        for (String col : columns) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(this.escapeColName(col));
            first = false;
        }
        sb.append(" FROM ");
        sb.append(this.escapeTableName(tableName));
        String sqlCmd = sb.toString();
        LOG.debug((Object)("Reading table with command: " + sqlCmd));
        return this.execute(sqlCmd, new Object[0]);
    }

    private String toDbSpecificJavaType(String tableName, String colName) {
        String colTypeName;
        if (this.columnTypeNames == null) {
            this.columnTypeNames = this.getColumnTypeNames(tableName, this.options.getCall(), this.options.getSqlQuery());
        }
        if ((colTypeName = this.columnTypeNames.get(colName)) != null) {
            if (colTypeName.equalsIgnoreCase("BINARY_FLOAT")) {
                return "Float";
            }
            if (colTypeName.equalsIgnoreCase("FLOAT")) {
                return "Float";
            }
            if (colTypeName.equalsIgnoreCase("BINARY_DOUBLE")) {
                return "Double";
            }
            if (colTypeName.equalsIgnoreCase("DOUBLE")) {
                return "Double";
            }
            if (colTypeName.toUpperCase().startsWith("TIMESTAMP")) {
                return "java.sql.Timestamp";
            }
        }
        return null;
    }

    private String toDbSpecificHiveType(String tableName, String colName) {
        if (this.columnTypeNames == null) {
            this.columnTypeNames = this.getColumnTypeNames(tableName, this.options.getCall(), this.options.getSqlQuery());
        }
        LOG.debug((Object)("Column Types and names returned = (" + StringUtils.join(this.columnTypeNames.keySet(), (String)",") + ")=>(" + StringUtils.join(this.columnTypeNames.values(), (String)",") + ")"));
        String colTypeName = this.columnTypeNames.get(colName);
        if (colTypeName != null) {
            if (colTypeName.equalsIgnoreCase("BINARY_FLOAT")) {
                return "FLOAT";
            }
            if (colTypeName.equalsIgnoreCase("BINARY_DOUBLE")) {
                return "DOUBLE";
            }
            if (colTypeName.toUpperCase().startsWith("TIMESTAMP")) {
                return "STRING";
            }
        }
        return null;
    }

    @Override
    public String toJavaType(String tableName, String columnName, int sqlType) {
        String javaType = super.toJavaType(tableName, columnName, sqlType);
        if (javaType == null) {
            javaType = this.toDbSpecificJavaType(tableName, columnName);
        }
        return javaType;
    }

    @Override
    public String toHiveType(String tableName, String columnName, int sqlType) {
        String hiveType = super.toHiveType(tableName, columnName, sqlType);
        if (hiveType == null) {
            hiveType = this.toDbSpecificHiveType(tableName, columnName);
        }
        return hiveType;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    protected String getCurTimestampQuery() {
        return "SELECT SYSDATE FROM dual";
    }

    @Override
    public String timestampToQueryString(Timestamp ts) {
        return "TO_TIMESTAMP('" + ts + "', 'YYYY-MM-DD HH24:MI:SS.FF')";
    }

    @Override
    public String datetimeToQueryString(String datetime, int columnType) {
        if (columnType == 93) {
            return "TO_TIMESTAMP('" + datetime + "', 'YYYY-MM-DD HH24:MI:SS.FF')";
        }
        if (columnType == 91) {
            datetime = datetime.split("\\.")[0];
            return "TO_DATE('" + datetime + "', 'YYYY-MM-DD HH24:MI:SS')";
        }
        String msg = "Column type is neither timestamp nor date!";
        LOG.error((Object)msg);
        throw new RuntimeException(msg);
    }

    @Override
    public boolean supportsStagingForExport() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listDatabases() {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rset = null;
        ArrayList<String> databases = new ArrayList<String>();
        try {
            conn = this.getConnection();
            stmt = conn.createStatement(1003, 1007);
            rset = stmt.executeQuery(QUERY_LIST_DATABASES);
            while (rset.next()) {
                databases.add(rset.getString(1));
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Failed to rollback transaction", ex);
            }
            if (e.getErrorCode() == 942) {
                LOG.error((Object)"The catalog view DBA_USERS was not found. This may happen if the user does not have DBA privileges. Please check privileges and try again.");
                LOG.debug((Object)"Full trace for ORA-00942 exception", (Throwable)e);
            } else {
                LoggingUtils.logAll(LOG, "Failed to list databases", e);
            }
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close statement", ex);
                }
            }
            try {
                this.close();
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Unable to discard connection", ex);
            }
        }
        return databases.toArray(new String[databases.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listTables() {
        Connection conn = null;
        Statement pStmt = null;
        ResultSet rset = null;
        ArrayList<String> tables = new ArrayList<String>();
        String tableOwner = null;
        try {
            conn = this.getConnection();
            tableOwner = OracleManager.getSessionUser(conn);
            pStmt = conn.prepareStatement(QUERY_LIST_TABLES, 1003, 1007);
            pStmt.setString(1, tableOwner);
            rset = pStmt.executeQuery();
            while (rset.next()) {
                tables.add(rset.getString(1));
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Failed to rollback transaction", ex);
            }
            LoggingUtils.logAll(LOG, "Failed to list tables", e);
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", ex);
                }
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close statement", ex);
                }
            }
            try {
                this.close();
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Unable to discard connection", ex);
            }
        }
        return tables.toArray(new String[tables.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getColumnNamesForProcedure(String procedureName) {
        String[] stringArray;
        ArrayList<String> ret = new ArrayList<String>();
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        ResultSet results = metaData.getProcedureColumns(null, null, procedureName, null);
        if (null == results) {
            return null;
        }
        try {
            while (results.next()) {
                int index;
                if (results.getInt("COLUMN_TYPE") == 5 || (index = results.getInt("ORDINAL_POSITION")) < 0) continue;
                for (int i = ret.size(); i < index; ++i) {
                    ret.add(null);
                }
                String name = results.getString("COLUMN_NAME");
                if (index == ret.size()) {
                    ret.add(name);
                    continue;
                }
                ret.set(index, name);
            }
            String[] result = ret.toArray(new String[ret.size()]);
            LOG.debug((Object)("getColumnsNamesForProcedure returns " + StringUtils.join(ret, (String)",")));
            stringArray = result;
        }
        catch (Throwable throwable) {
            try {
                results.close();
                this.getConnection().commit();
                throw throwable;
            }
            catch (SQLException e) {
                LoggingUtils.logAll(LOG, "Error reading procedure metadata: ", e);
                throw new RuntimeException("Can't fetch column names for procedure.", e);
            }
        }
        results.close();
        this.getConnection().commit();
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getColumnTypesForProcedure(String procedureName) {
        TreeMap<String, Integer> treeMap;
        TreeMap<String, Integer> ret = new TreeMap<String, Integer>();
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        ResultSet results = metaData.getProcedureColumns(null, null, procedureName, null);
        if (null == results) {
            return null;
        }
        try {
            while (results.next()) {
                int index;
                if (results.getInt("COLUMN_TYPE") == 5 || (index = results.getInt("ORDINAL_POSITION")) < 0) continue;
                ret.put(results.getString("COLUMN_NAME"), results.getInt("DATA_TYPE"));
            }
            LOG.debug((Object)("Columns returned = " + StringUtils.join(ret.keySet(), (String)",")));
            LOG.debug((Object)("Types returned = " + StringUtils.join(ret.values(), (String)",")));
            treeMap = ret.isEmpty() ? null : ret;
        }
        catch (Throwable throwable) {
            try {
                results.close();
                this.getConnection().commit();
                throw throwable;
            }
            catch (SQLException sqlException) {
                LoggingUtils.logAll(LOG, "Error reading primary key metadata: " + sqlException.toString(), sqlException);
                return null;
            }
        }
        results.close();
        this.getConnection().commit();
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getColumnTypeNamesForProcedure(String procedureName) {
        TreeMap<String, String> treeMap;
        TreeMap<String, String> ret = new TreeMap<String, String>();
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        ResultSet results = metaData.getProcedureColumns(null, null, procedureName, null);
        if (null == results) {
            return null;
        }
        try {
            while (results.next()) {
                int index;
                if (results.getInt("COLUMN_TYPE") == 5 || (index = results.getInt("ORDINAL_POSITION")) < 0) continue;
                ret.put(results.getString("COLUMN_NAME"), results.getString("TYPE_NAME"));
            }
            LOG.debug((Object)("Columns returned = " + StringUtils.join(ret.keySet(), (String)",")));
            LOG.debug((Object)("Type names returned = " + StringUtils.join(ret.values(), (String)",")));
            treeMap = ret.isEmpty() ? null : ret;
        }
        catch (Throwable throwable) {
            try {
                results.close();
                this.getConnection().commit();
                throw throwable;
            }
            catch (SQLException sqlException) {
                LoggingUtils.logAll(LOG, "Error reading primary key metadata: " + sqlException.toString(), sqlException);
                return null;
            }
        }
        results.close();
        this.getConnection().commit();
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getColumnNames(String tableName) {
        Connection conn = null;
        Statement pStmt = null;
        ResultSet rset = null;
        ArrayList<String> columns = new ArrayList<String>();
        String tableOwner = null;
        String shortTableName = tableName;
        int qualifierIndex = tableName.indexOf(46);
        if (qualifierIndex != -1) {
            tableOwner = tableName.substring(0, qualifierIndex);
            shortTableName = tableName.substring(qualifierIndex + 1);
        }
        try {
            conn = this.getConnection();
            if (tableOwner == null) {
                tableOwner = OracleManager.getSessionUser(conn);
            }
            pStmt = conn.prepareStatement(QUERY_COLUMNS_FOR_TABLE, 1003, 1007);
            pStmt.setString(1, tableOwner);
            pStmt.setString(2, shortTableName);
            rset = pStmt.executeQuery();
            while (rset.next()) {
                columns.add(rset.getString(1));
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Failed to rollback transaction", ex);
            }
            LoggingUtils.logAll(LOG, "Failed to list columns", e);
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", ex);
                }
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close statement", ex);
                }
            }
            try {
                this.close();
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Unable to discard connection", ex);
            }
        }
        return columns.toArray(new String[columns.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrimaryKey(String tableName) {
        Connection conn = null;
        Statement pStmt = null;
        ResultSet rset = null;
        ArrayList<String> columns = new ArrayList<String>();
        String tableOwner = null;
        String shortTableName = tableName;
        int qualifierIndex = tableName.indexOf(46);
        if (qualifierIndex != -1) {
            tableOwner = tableName.substring(0, qualifierIndex);
            shortTableName = tableName.substring(qualifierIndex + 1);
        }
        try {
            conn = this.getConnection();
            if (tableOwner == null) {
                tableOwner = OracleManager.getSessionUser(conn);
            }
            pStmt = conn.prepareStatement(QUERY_PRIMARY_KEY_FOR_TABLE, 1003, 1007);
            pStmt.setString(1, shortTableName);
            pStmt.setString(2, tableOwner);
            rset = pStmt.executeQuery();
            while (rset.next()) {
                columns.add(rset.getString(1));
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Failed to rollback transaction", ex);
            }
            LoggingUtils.logAll(LOG, "Failed to list columns", e);
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", ex);
                }
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close statement", ex);
                }
            }
            try {
                this.close();
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Unable to discard connection", ex);
            }
        }
        if (columns.size() == 0) {
            return null;
        }
        if (columns.size() > 1) {
            LOG.warn((Object)("The table " + tableName + " " + "contains a multi-column primary key. Sqoop will default to " + "the column " + (String)columns.get(0) + " only for this job."));
        }
        return (String)columns.get(0);
    }

    @Override
    public String getInputBoundsQuery(String splitByCol, String sanitizedQuery) {
        return "SELECT MIN(" + splitByCol + "), MAX(" + splitByCol + ") FROM (" + sanitizedQuery + ") t1";
    }

    private static class ConnCache {
        public static final Log LOG = LogFactory.getLog((String)ConnCache.class.getName());
        private Map<CacheKey, Connection> connectionMap;

        public ConnCache() {
            LOG.debug((Object)"Instantiated new connection cache.");
            this.connectionMap = new HashMap<CacheKey, Connection>();
        }

        public synchronized Connection getConnection(String connectStr, String username) throws SQLException {
            CacheKey key = new CacheKey(connectStr, username);
            Connection cached = this.connectionMap.get(key);
            if (null != cached) {
                this.connectionMap.remove(key);
                if (cached.isReadOnly()) {
                    cached.close();
                }
                if (cached.isClosed()) {
                    return null;
                }
                cached.rollback();
                cached.clearWarnings();
                LOG.debug((Object)("Got cached connection for " + key));
            }
            return cached;
        }

        public synchronized void recycle(String connectStr, String username, Connection conn) throws SQLException {
            CacheKey key = new CacheKey(connectStr, username);
            Connection existing = this.connectionMap.get(key);
            if (null != existing) {
                LOG.debug((Object)("Discarding additional connection for " + key));
                conn.close();
                return;
            }
            LOG.debug((Object)("Caching released connection for " + key));
            this.connectionMap.put(key, conn);
        }

        protected synchronized void finalize() throws Throwable {
            for (Connection c : this.connectionMap.values()) {
                c.close();
            }
            super.finalize();
        }

        private static class CacheKey {
            private final String connectString;
            private final String username;

            public CacheKey(String connect, String user) {
                this.connectString = connect;
                this.username = user;
            }

            public boolean equals(Object o) {
                if (o instanceof CacheKey) {
                    CacheKey k = (CacheKey)o;
                    if (null == this.username) {
                        return k.username == null && k.connectString.equals(this.connectString);
                    }
                    return k.username.equals(this.username) && k.connectString.equals(this.connectString);
                }
                return false;
            }

            public int hashCode() {
                if (null == this.username) {
                    return this.connectString.hashCode();
                }
                return this.username.hashCode() ^ this.connectString.hashCode();
            }

            public String toString() {
                return this.connectString + "/" + this.username;
            }
        }
    }
}

