#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh

# 根据site_name来判断数据库名称
if [ $1 == all ];
then
    site_name_array=(uk de es fr it us)
else
    site_name_array=($1)
fi
echo "site_name_array: ${site_name_array}"

date_type=$2
date_info=$3
d1=`echo $date_info | cut -d \- -f 1`
d2=`echo $date_info | cut -d \- -f 2`

for site_name in ${site_name_array[*]}
    do
		echo 1. 当前连接的数据库站点: ${site_name}
		if [ ${site_name} == us ];
		then
			db=selection
		else
			db=selection_${site_name}
		fi
		echo "db: ${db}"

		# 导出数据
		import_table=${site_name}_seller_category_agg
		hive_table=dwt_fd_category_agg
		echo import_table:$import_table, hive_table:$hive_table
		#db_type=postgresql
		db_type=mysql
		maps=10
		p_keys="site_name,date_type,date_info"
		p_values="$site_name,$date_type,$date_info"
		cols="fd_account_id,bsr_cate_1_id,fd_cate_asin_num,fd_cate_new_asin_num,fd_asin_num,bsr_asin_num,fd_cate_asin_per,fd_cate_new_asin_per,fd_market_per,ym,week"
		export_data
	done
