from utils.datahub_util import build_column_lineages

to_tb = "dim_bsr_asin_rank_history"
sources = [
    {
        "form": "ods_bs_category_top100_asin",
        "mappings": [
            ("asin", "asin"),
            ("cate_current_id", "old_category_id"),
            ("category_id", "category_id"),
            ("bsr_rank", "bsr_rank"),
            ("rating", "asin_rating"),
            ("total_comments", "asin_total_comments"),
            ("updated_at", "updated_at"),
            ("date_info", "date_info"),
            ("site_name", "site_name"),
        ]
    },
]

if __name__ == '__main__':
    config = []
    for source in sources:
        for mapping in source["mappings"]:
            config.append(
                {
                    "from": f"{source['form']}.{mapping[0]}",
                    "to": f"{to_tb}.{mapping[1]}",
                },
            )
            pass

    url = build_column_lineages(config)
    print(url)
    pass

pass
