import os
import sys
import pandas as pd

sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
from utils.utils import Utils


class ExportDimStYearWeek(Utils):
    def __init__(self, site_name='us'):
        """
        默认导入所有站点的所有data_type类型的表
        """
        super(ExportDimStYearWeek, self).__init__()
        self.site_name = site_name
        self.connection(db_type="mysql", db_conn="mysql_aliyun")  # mysql连接
        self.year = year
        self.week = week
        self.year_week = f"{self.year}-{self.week}"
        self.path_sh = f"/opt/module/spark/demo/py_demo/demo_sqoop/export_dim_st_year_week.sh"
        print(f"self.site_name: {self.site_name}, self.year_week: {self.year_week}")

    def export_data(self):
        print("开始导出数据")
        print("1. 建表")
        with self.engine.begin() as conn:
            sql_drop = f"drop table if exists {self.site_name}_st_year_week_copy1;"
            sql_create = f"""
            CREATE TABLE `{self.site_name}_st_year_week_copy1` (
              `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
              `search_term` varchar(500) NOT NULL COMMENT '搜索词',
              `year_week` varchar(10) DEFAULT NULL COMMENT '年-周',
              `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
              `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
              PRIMARY KEY (`id`),
              KEY `seq_year_week` (`year_week`) USING BTREE,
              KEY `seq_search_term` (`search_term`,`year_week`) USING BTREE
            ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;
            """.replace("`", "")
            conn.execute(sql_drop)
            conn.execute(sql_create)
        print("2. 导出")
        os.system(f"{self.path_sh} {self.site_name} {self.year} {self.week}")

    def check_data(self):
        num = 0
        while True:
            num += 1
            print("开始检查数据")
            sql_read = f"SELECT max(year_week) as max_year_week FROM {self.site_name}_st_year_week_copy1;"
            df = pd.read_sql(sql_read, con=self.engine)
            max_year_week = list(df.max_year_week)[0] if list(df.max_year_week) else ''
            print(self.year_week, max_year_week)
            if self.year_week <= max_year_week:
                print(f"正常导出站点：{self.site_name}的数据")
                print("3. 删除正式表，将copy表改成正式表")
                with self.engine.begin() as conn:
                    sql_drop = f"drop table if exists {self.site_name}_st_year_week;"
                    sql_rename = f"ALTER TABLE {self.site_name}_st_year_week_copy1 RENAME {self.site_name}_st_year_week;"
                    conn.execute(sql_drop)
                    conn.execute(sql_rename)
                break
            else:
                if num > 3:
                    print("检查次数超过3次异常，停止")
                    break
                else:
                    print(f"第{num}次检查异常，继续导出检查")
                    self.export_data()
                    continue

    def run(self):
        self.export_data()
        self.check_data()


if __name__ == '__main__':
    site_name = sys.argv[1]  # 参数1：site_name列表-->all:所有站点
    year = sys.argv[2]  # 参数2：年
    week = sys.argv[3]  # 参数2：周
    handle_obj = ExportDimStYearWeek(site_name=site_name)
    handle_obj.run()