import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.common_util import CommonUtil
from utils.secure_db_client import get_remote_engine

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    st_type = CommonUtil.get_sys_arg(2, None)
    date_type = CommonUtil.get_sys_arg(3, None)
    date_info = CommonUtil.get_sys_arg(4, None)
    assert site_name is not None, "site_name 不能为空！"
    assert st_type is not None, "st_type 不能为空！"
    assert date_type is not None, "date_type 不能为空！"
    assert date_info is not None, "date_info 不能为空！"

    if site_name == 'uk' and st_type == 'ac':
        print("uk站点已无ac类型词，退出执行！")
        sys.exit(0)

    if st_type in ["zr", "sp"]:
        cols = "search_term,asin,page,page_row,created_time,updated_time,id"
    elif st_type in ["sb", "tr"]:
        cols = "search_term,asin,page,data_type,created_time,updated_time,id"
    else:
        cols = "search_term,asin,page,created_time,updated_time,id"

    db_type = 'postgresql_14'
    d1, d2 = CommonUtil.split_month_week_date(date_type, date_info)
    d2 = f'0{d2}' if int(d2) < 10 else f'{d2}'
    import_tb = f"{site_name}_search_term_rank_{st_type}_month_{d1}_{d2}"
    query = f"""
        select {cols} from {import_tb} where 1 = 1 and \$CONDITIONS
    """
    print(f"当前链接的数据库为：{db_type}，同步的表为：{import_tb}")

    hive_tb = f"ods_search_term_{st_type}"
    partition_dict = {
        "site_name": site_name,
        "date_type": date_type,
        "date_info": date_info,
    }
    hdfs_path = CommonUtil.build_hdfs_path(hive_tb, partition_dict=partition_dict)

    if st_type == "zr":
        if site_name == "us":
            map_num = 40
        else:
            map_num = 15
    elif st_type in ["sb", "sp"]:
        if site_name == "us":
            map_num = 6
        else:
            map_num = 2
    else:
        map_num = 1

    engine = get_remote_engine(
        site_name=site_name,
        db_type=db_type
    )

    engine.sqoop_raw_import(
        query=query,
        hive_table=hive_tb,
        hdfs_path=hdfs_path,
        partitions=partition_dict,
        m=map_num,
        split_by='id'
    )

    pass
